/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;

public class DashDodgeTargetGoal
extends TickedGoal<MobEntity> {
    private LivingEntity target;
    private float ticksBetweenDashes;
    private float dashDistance;
    private boolean isSurrounded;
    private Predicate<LivingEntity> canUseTest = Predicates.alwaysTrue();

    public DashDodgeTargetGoal(MobEntity entity, float ticksBetweenDashes, float dashDistance) {
        super(entity);
        this.ticksBetweenDashes = ticksBetweenDashes;
        this.dashDistance = dashDistance;
    }

    public boolean func_75250_a() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!this.hasTimePassedSinceLastEnd(this.ticksBetweenDashes)) {
            return false;
        }
        if (!AbilityHelper.canUseMomentumAbilities((LivingEntity)this.entity)) {
            return false;
        }
        if (!GoalUtil.canSee(this.entity, this.target)) {
            return false;
        }
        if (GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, 10.0)) {
            return false;
        }
        if (DevilFruitHelper.getDifferenceToFloor((Entity)this.entity) > 3.0) {
            return false;
        }
        if (!GoalUtil.isEntityInView(this.target, (Entity)this.entity)) {
            return false;
        }
        return this.canUseTest.test((LivingEntity)this.entity);
    }

    public boolean func_75253_b() {
        return false;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        if (!this.isSurrounded) {
            GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
            Vector3d dir = this.target.func_213303_ch().func_178788_d(this.entity.func_213303_ch()).func_72432_b().func_216372_d((double)this.dashDistance, 1.0, (double)this.dashDistance);
            this.entity.func_213293_j(-dir.field_72450_a, 0.1, -dir.field_72449_c);
            this.entity.field_70133_I = true;
        }
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
    }

    public void setCanUseTest(Predicate<LivingEntity> test) {
        this.canUseTest = test;
    }
}

