/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class EatNearbyFishGoal
extends TickedGoal<MobEntity> {
    private static final int COOLDOWN = 40;
    private List<AbstractFishEntity> fishes = new ArrayList<AbstractFishEntity>();
    private AbstractFishEntity target;
    private long lastCheck = 0L;
    private boolean justAte = false;

    public EatNearbyFishGoal(MobEntity entity) {
        super(entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        if (GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (this.lastCheck == 0L) {
            this.lastCheck = this.entity.field_70170_p.func_82737_E();
            return false;
        }
        if (!this.hasTimePassedSinceLastCheck(40.0f)) {
            return false;
        }
        if (!this.hasTimePassedSinceLastEnd(40.0f)) {
            return false;
        }
        this.fishes = WyHelper.getNearbyEntities(this.entity.func_213303_ch(), (IWorld)this.entity.field_70170_p, this.getFollowDistance(), null, AbstractFishEntity.class);
        if (this.fishes.size() <= 0) {
            this.lastCheck = this.entity.field_70170_p.func_82737_E();
            return false;
        }
        this.target = this.fishes.get(0);
        return true;
    }

    public boolean func_75253_b() {
        if (this.target == null || !this.target.func_70089_S()) {
            return false;
        }
        return !this.justAte;
    }

    protected double getFollowDistance() {
        return this.entity.func_233637_b_(Attributes.field_233819_b_);
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.justAte = false;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.entity.field_70173_aa % 20 == 0) {
            this.entity.func_70661_as().func_75497_a((Entity)this.target, 1.2);
        }
        if (this.target != null && this.entity.func_70068_e((Entity)this.target) < 25.0) {
            this.target.func_70106_y();
            this.entity.field_70170_p.func_72960_a((Entity)this.target, (byte)3);
            for (int i = 0; i < 20; ++i) {
                double d0 = this.entity.func_70681_au().nextGaussian() * 0.02;
                double d1 = this.entity.func_70681_au().nextGaussian() * 0.02;
                double d2 = this.entity.func_70681_au().nextGaussian() * 0.02;
                this.entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.entity.func_226282_d_(1.0), this.entity.func_226279_cv_(), this.entity.func_226287_g_(1.0), d0, d1, d2);
            }
            this.justAte = true;
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }

    public boolean hasTimePassedSinceLastCheck(float ticks) {
        return (float)this.entity.field_70170_p.func_82737_E() >= (float)this.lastCheck + ticks;
    }
}

