/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import java.util.function.Supplier;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class ImprovedMeleeAttackGoal
extends MeleeAttackGoal {
    private boolean moveTowardsTarget = true;
    private int attackInterval = 20;
    private int ticksUntilNextAttack;
    private boolean longMemory;
    private Supplier<Boolean> earlyStop = () -> false;

    public ImprovedMeleeAttackGoal(CreatureEntity entity, double speed, boolean useLongMemory) {
        super(entity, speed, useLongMemory);
        this.longMemory = useLongMemory;
    }

    public ImprovedMeleeAttackGoal setAttackInterval(int interval) {
        this.attackInterval = interval;
        return this;
    }

    public ImprovedMeleeAttackGoal setMoveTowardsTarget(boolean flag) {
        this.moveTowardsTarget = flag;
        return this;
    }

    public ImprovedMeleeAttackGoal setEarlyStop(Supplier<Boolean> earlyStop) {
        this.earlyStop = earlyStop;
        return this;
    }

    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (!GoalUtil.hasAliveTarget((MobEntity)this.field_75441_b)) {
            return false;
        }
        LivingEntity target = this.field_75441_b.func_70638_az();
        if (AbilityHelper.isInCreativeOrSpectator(target)) {
            return false;
        }
        if (this.field_75441_b.func_213283_Z() == Pose.CROUCHING || this.field_75441_b.func_213283_Z() == Pose.DYING || this.field_75441_b.func_213283_Z() == Pose.SLEEPING) {
            return false;
        }
        return this.earlyStop.get() == false;
    }

    public boolean func_75253_b() {
        LivingEntity target = this.field_75441_b.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (this.earlyStop.get().booleanValue()) {
            return false;
        }
        if (AbilityHelper.isInCreativeOrSpectator(target)) {
            return false;
        }
        if (target.func_82150_aj()) {
            return false;
        }
        if (this.field_75441_b.func_213283_Z() == Pose.CROUCHING || this.field_75441_b.func_213283_Z() == Pose.DYING || this.field_75441_b.func_213283_Z() == Pose.SLEEPING) {
            return false;
        }
        return this.longMemory || !this.field_75441_b.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.ticksUntilNextAttack = 0;
    }

    public void func_75246_d() {
        boolean lastAttackIsStale;
        boolean isInvisible;
        LivingEntity target = this.field_75441_b.func_70638_az();
        boolean bl = isInvisible = target != null && target.func_70644_a(Effects.field_76441_p);
        if (target == null || !target.func_70089_S()) {
            return;
        }
        boolean bl2 = lastAttackIsStale = !AbilityHelper.isInCreativeOrSpectator(target) && this.field_75441_b.func_70068_e((Entity)target) < 5.0 && this.field_75441_b.field_70173_aa >= this.field_75441_b.func_142013_aG() + 100;
        if (lastAttackIsStale && target.func_233570_aj_() && this.field_75441_b.func_233570_aj_()) {
            Vector3d look = this.field_75441_b.func_70040_Z().func_216372_d(0.4, 0.4, 0.4);
            this.field_75441_b.func_213317_d(this.field_75441_b.func_213322_ci().func_178787_e(look));
        }
        if (isInvisible) {
            this.field_75441_b.func_70624_b((LivingEntity)null);
            return;
        }
        super.func_75246_d();
        if (!this.moveTowardsTarget) {
            this.field_75441_b.func_70661_as().func_75499_g();
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
    }

    protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
        if (!GoalUtil.canSee((MobEntity)this.field_75441_b, enemy)) {
            return;
        }
        double d0 = this.func_179512_a(enemy);
        if (distToEnemySqr <= d0 && this.func_234040_h_()) {
            this.func_234039_g_();
            this.field_75441_b.func_184609_a(Hand.MAIN_HAND);
            this.field_75441_b.func_70652_k((Entity)enemy);
        }
    }

    protected boolean func_234040_h_() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected void func_234039_g_() {
        super.func_234039_g_();
        this.ticksUntilNextAttack = this.func_234042_k_();
    }

    protected int func_234042_k_() {
        return this.attackInterval;
    }

    protected double func_179512_a(LivingEntity target) {
        double attrReach = this.field_75441_b.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111126_e();
        attrReach = Math.max(1.0, attrReach);
        return (double)(this.field_75441_b.func_213311_cf() * 2.0f * this.field_75441_b.func_213311_cf() * 2.0f + target.func_213311_cf()) * attrReach;
    }
}

