/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class SwimUpOnDrowningGoal
extends TickedGoal<CreatureEntity> {
    private static final int MAX_AIR_ATTEMPTS = 20;
    private static final int NEXT_AIR_ATTEMPT_COOLDOWN = 300;
    private IEntityStats entityStats;
    private boolean isDrowining;
    private BlockPos surfacePosition;
    private int airAttempts = 0;
    private long lastAirAttempt = 0L;

    public SwimUpOnDrowningGoal(CreatureEntity entity) {
        super(entity);
        this.entityStats = EntityStatsCapability.get((LivingEntity)entity);
    }

    public boolean func_75250_a() {
        if (this.entityStats.isFishman()) {
            return false;
        }
        if (!((CreatureEntity)this.entity).func_208600_a((ITag)FluidTags.field_206959_a)) {
            return false;
        }
        return ((CreatureEntity)this.entity).func_70086_ai() < ((CreatureEntity)this.entity).func_205010_bg() / 2 || ((CreatureEntity)this.entity).func_189748_bU() == DamageSource.field_76369_e;
    }

    public boolean func_75253_b() {
        if (!((CreatureEntity)this.entity).func_208600_a((ITag)FluidTags.field_206959_a)) {
            return false;
        }
        return ((CreatureEntity)this.entity).func_70086_ai() < ((CreatureEntity)this.entity).func_205010_bg() / 2;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.isDrowining = true;
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        mutpos.func_189533_g((Vector3i)((CreatureEntity)this.entity).func_233580_cy_());
        if (((CreatureEntity)this.entity).field_70170_p.func_226660_f_(((CreatureEntity)this.entity).func_233580_cy_())) {
            for (int i = 0; i < 20; ++i) {
                FluidState fluidState = ((CreatureEntity)this.entity).field_70170_p.func_204610_c(mutpos.func_177981_b(i));
                if (!fluidState.func_206888_e()) continue;
                this.surfacePosition = mutpos.func_185334_h();
                break;
            }
        } else {
            this.tryFindingAir();
        }
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.surfacePosition != null) {
            ((CreatureEntity)this.entity).func_70661_as().func_75499_g();
            ((CreatureEntity)this.entity).func_70661_as().func_75492_a((double)this.surfacePosition.func_177958_n(), (double)this.surfacePosition.func_177956_o(), (double)this.surfacePosition.func_177952_p(), (double)1.55f);
        } else if (((CreatureEntity)this.entity).field_70170_p.func_82737_E() >= this.lastAirAttempt + 300L) {
            this.tryFindingAir();
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.isDrowining = false;
        this.surfacePosition = null;
        this.airAttempts = 0;
    }

    private void tryFindingAir() {
        while (this.airAttempts < 20) {
            this.surfacePosition = this.lookForAir((IBlockReader)((CreatureEntity)this.entity).field_70170_p, 40, 40);
            if (this.surfacePosition != null) break;
            ++this.airAttempts;
        }
        this.lastAirAttempt = ((CreatureEntity)this.entity).field_70170_p.func_82737_E();
    }

    @Nullable
    protected BlockPos lookForAir(IBlockReader level, int horizontalRange, int verticalRange) {
        BlockPos blockpos = ((CreatureEntity)this.entity).func_233580_cy_();
        int x0 = blockpos.func_177958_n();
        int y0 = blockpos.func_177956_o();
        int z0 = blockpos.func_177952_p();
        float f = horizontalRange * horizontalRange * verticalRange * 2;
        BlockPos targetPosition = null;
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        for (int x = x0 - horizontalRange; x <= x0 + horizontalRange; ++x) {
            for (int y = y0 - verticalRange; y <= y0 + verticalRange; ++y) {
                for (int z = z0 - horizontalRange; z <= z0 + horizontalRange; ++z) {
                    float dist;
                    mutpos.func_181079_c(x, y, z);
                    if (!level.func_204610_c((BlockPos)mutpos).func_206888_e() || !((dist = (float)((x - x0) * (x - x0) + (y - y0) * (y - y0) + (z - z0) * (z - z0))) < f)) continue;
                    f = dist;
                    targetPosition = mutpos.func_185334_h();
                }
            }
        }
        return targetPosition;
    }
}

