/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityGoal2;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DodgeGoal
extends AbilityGoal2<CreatureEntity> {
    private int usage;
    private int usagePower = 10;
    private int restoreTime = 40;
    private int restorePower = 10;
    private int successRate = 50;
    private Vector3d dodgeDistance = new Vector3d(1.25, 0.0, 1.25);
    private double minDistance = -1.0;
    private Interval dodgeInterval = new Interval(5);
    private Interval restorenterval;
    private Predicate<Entity> isNotOwnThrowable;

    public DodgeGoal(CreatureEntity entity) {
        super(entity);
        this.setDefaultCooldown(10.0f);
        this.restorenterval = new Interval(this.restoreTime);
    }

    public DodgeGoal setMinDistance(double dist) {
        this.minDistance = dist;
        return this;
    }

    public DodgeGoal setDodgeDistance(double x, double y, double z) {
        this.dodgeDistance = new Vector3d(x, y, z);
        return this;
    }

    public DodgeGoal setSuccessRate(int rate) {
        this.successRate = rate;
        return this;
    }

    public DodgeGoal setUsagePower(int power) {
        this.usagePower = power;
        return this;
    }

    public DodgeGoal setRestoreTime(int time) {
        this.restoreTime = time;
        this.restorenterval = new Interval(this.restoreTime);
        return this;
    }

    public DodgeGoal setRestorePower(int power) {
        this.restorePower = power;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return this.usage < 100;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.isNotOwnThrowable = e -> e instanceof ThrowableEntity && ((ThrowableEntity)e).func_234616_v_() != this.entity;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.dodgeInterval.canTick()) {
            int distance = 10;
            List<ThrowableEntity> dangers = WyHelper.getNearbyEntities(((CreatureEntity)this.entity).func_213303_ch(), (IWorld)((CreatureEntity)this.entity).field_70170_p, (double)distance, distance, distance, this.isNotOwnThrowable, ThrowableEntity.class);
            if (dangers.size() > 0) {
                int dodges = 0;
                Vector3d entityPos = ((CreatureEntity)this.entity).func_213303_ch();
                for (ThrowableEntity danger : dangers) {
                    if (this.minDistance > 0.0 && danger.func_234616_v_() != null && danger.func_234616_v_().func_70068_e((Entity)this.entity) < this.minDistance * this.minDistance) continue;
                    if (((CreatureEntity)this.entity).func_70681_au().nextInt(100) > this.successRate) {
                        ++dodges;
                        continue;
                    }
                    Vector3d pos = danger.func_213303_ch();
                    Vector3d dir = entityPos.func_178788_d(pos).func_72432_b().func_216369_h(this.dodgeDistance);
                    ((CreatureEntity)this.entity).func_213293_j(dir.field_72450_a, ((CreatureEntity)this.entity).func_213322_ci().field_72448_b, dir.field_72449_c);
                    ((CreatureEntity)this.entity).field_70133_I = true;
                    ++dodges;
                }
                this.usage += this.usagePower * dodges;
            }
        }
        if (this.restorenterval.canTick()) {
            this.usage -= this.restorePower;
            this.usage = MathHelper.func_76125_a((int)this.usage, (int)0, (int)100);
        }
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.usage = 0;
    }
}

