/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.world.Difficulty;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShockwaveAttackGoal
extends CooldownGoal {
    private int hitCount;
    private int maxCount;
    private int duration;
    private final int maxDuration;
    private float prevHealth;
    private int animationId;
    private boolean canBreakBlocks;

    public ShockwaveAttackGoal(OPEntity entity, int hitCount) {
        this(entity, hitCount, false);
    }

    public ShockwaveAttackGoal(OPEntity entity, int hitCount, boolean canBreakBlocks) {
        super(entity);
        this.setMaxCooldown(5.0);
        this.duration = 40;
        this.maxCount = hitCount;
        this.prevHealth = this.entity.func_110143_aJ();
        this.canBreakBlocks = canBreakBlocks;
        this.maxDuration = 5;
    }

    public ShockwaveAttackGoal setAnimationId(int id) {
        this.animationId = id;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        boolean hasEnemyInSight;
        if (this.entity.func_110143_aJ() < this.prevHealth) {
            ++this.hitCount;
            this.prevHealth = this.entity.func_110143_aJ();
        }
        boolean shouldExecute = super.func_75250_a() || this.hitCount >= this.maxCount;
        boolean hasTarget = this.entity.func_70638_az() != null;
        boolean bl = hasEnemyInSight = hasTarget && this.entity.func_70685_l((Entity)this.entity.func_70638_az());
        return shouldExecute && hasTarget && hasEnemyInSight;
    }

    @Override
    public boolean func_75253_b() {
        ++this.duration;
        boolean continueExecution = false;
        if (this.duration < this.maxDuration) {
            continueExecution = true;
        }
        if (!continueExecution) {
            this.entity.setAnimation(0);
            this.hitCount = 0;
            this.maxCount = (int)Math.abs(WyHelper.randomWithRange(this.maxCount - 2, this.maxCount + 2));
            this.setOnCooldown(true);
        }
        return continueExecution;
    }

    @Override
    public void endCooldown() {
        this.duration = 0;
    }

    @Override
    public void duringCooldown() {
    }

    public void func_75249_e() {
        this.entity.setAnimation(this.animationId);
        double x = this.entity.func_70638_az().func_226277_ct_() - this.entity.func_226277_ct_() + (this.entity.field_70170_p.func_175659_aa().func_151525_a() >= Difficulty.HARD.func_151525_a() ? this.entity.func_70681_au().nextGaussian() : 0.0);
        double y = this.entity.func_70638_az().func_174813_aQ().field_72338_b + (double)(this.entity.func_70638_az().func_213302_cg() / 2.0f) - (this.entity.func_226278_cu_() + (double)(this.entity.func_213302_cg() / 2.0f));
        double z = this.entity.func_70638_az().func_226281_cx_() - this.entity.func_226281_cx_() + (this.entity.field_70170_p.func_175659_aa().func_151525_a() >= Difficulty.HARD.func_151525_a() ? this.entity.func_70681_au().nextGaussian() : 0.0);
    }
}

