/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import xyz.pixelatedw.mineminenomi.abilities.bomu.BreezeBreathBombAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.items.weapons.ModGunItem;

public class BreezeBreathBombWrapperGoal
extends AbilityWrapperGoal<MobEntity, BreezeBreathBombAbility> {
    private ItemStack heldItemStack;
    private LivingEntity target;
    private boolean forceUse;

    public BreezeBreathBombWrapperGoal(MobEntity entity) {
        super(entity, BreezeBreathBombAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (this.forceUse) {
            return true;
        }
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        this.heldItemStack = this.entity.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!this.hasGunInHand()) {
            return false;
        }
        return !GoalUtil.hasHealthAbovePercentage((LivingEntity)this.entity, 90.0);
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return false;
    }

    public boolean hasGunInHand() {
        return !this.heldItemStack.func_190926_b() && this.heldItemStack.func_77973_b() instanceof ModGunItem;
    }

    @Override
    public void startWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
        ((BreezeBreathBombAbility)this.getAbility()).getComponent(ModAbilityKeys.PROJECTILE).ifPresent(comp -> comp.shoot((LivingEntity)this.entity));
        this.forceUse = false;
    }

    @Override
    public void tickWrapper() {
    }

    @Override
    public void stopWrapper() {
    }

    public boolean isForced() {
        return this.forceUse;
    }

    public void forceUse() {
        this.forceUse = true;
    }
}

