/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.abilities.cyborg.RadicalBeamAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class RadicalBeamWrapperGoal
extends AbilityWrapperGoal<MobEntity, RadicalBeamAbility> {
    private LivingEntity target;
    private double minDistance = 1.0;
    private double maxDistance = 50.0;

    public RadicalBeamWrapperGoal(MobEntity entity) {
        super(entity, RadicalBeamAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.canSee(this.entity, this.target)) {
            return false;
        }
        if (GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.minDistance)) {
            return false;
        }
        return !GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.maxDistance);
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return true;
    }

    @Override
    public void startWrapper() {
        ((RadicalBeamAbility)this.getAbility()).getComponent(ModAbilityKeys.ANIMATION).get().start((LivingEntity)this.entity, ModAnimations.HEAD_LASER_CHARGE);
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void tickWrapper() {
        this.entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0));
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void stopWrapper() {
        ((RadicalBeamAbility)this.getAbility()).getComponent(ModAbilityKeys.ANIMATION).get().stop((LivingEntity)this.entity);
    }
}

