/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.TekkaiAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TekkaiWrapperGoal
extends AbilityWrapperGoal<MobEntity, TekkaiAbility> {
    private LivingEntity target;
    private double distance = 10.0;
    private int lastHurtTicks = (int)WyHelper.secondsToTicks(5.0f);

    public TekkaiWrapperGoal(MobEntity entity) {
        super(entity, TekkaiAbility.INSTANCE);
    }

    public TekkaiWrapperGoal setMinDistance(double distance) {
        this.distance = distance;
        return this;
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.distance)) {
            return false;
        }
        return this.entity.func_142015_aE() > 0 && this.entity.field_70173_aa <= this.entity.func_142015_aE() + this.lastHurtTicks;
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.distance * 1.5);
    }

    @Override
    public void startWrapper() {
        FluidState fluidState = this.entity.field_70170_p.func_204610_c(this.entity.func_233580_cy_());
        if (!fluidState.func_206888_e()) {
            ((TekkaiAbility)this.getAbility()).switchToWalkMode(this.target);
        } else {
            ((TekkaiAbility)this.getAbility()).switchToHeavyMode(this.target);
        }
    }

    @Override
    public void tickWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void stopWrapper() {
    }
}

