/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.Hand;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;

public abstract class ChargeSniperAbilityGoal<E extends MobEntity, A extends IAbility>
extends AbilityWrapperGoal<E, A> {
    private boolean fired;
    private LivingEntity target;
    private double distance = 2.0;
    private int chargeup;
    private final int maxChargeup;

    public ChargeSniperAbilityGoal(E entity, AbilityCore<A> core, int chargeup) {
        super(entity, core);
        this.maxChargeup = chargeup;
    }

    public ChargeSniperAbilityGoal<E, A> setMinDistance(double distance) {
        this.distance = distance;
        return this;
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.canSee(this.entity, this.target)) {
            return false;
        }
        return !GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.distance);
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return !this.fired;
    }

    @Override
    public void startWrapper() {
        this.fired = false;
        this.entity.func_184598_c(Hand.MAIN_HAND);
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void tickWrapper() {
        ++this.chargeup;
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
        if (this.chargeup >= this.maxChargeup && !this.fired) {
            this.entity.func_184597_cx();
            this.fired = true;
        }
    }

    @Override
    public void stopWrapper() {
    }

    public LivingEntity getTarget() {
        return this.target;
    }
}

