/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.marines;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.TraderEntity;
import xyz.pixelatedw.mineminenomi.api.enums.Currency;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;

public class MarineTraderEntity
extends TraderEntity {
    public MarineTraderEntity(EntityType type, World world) {
        super(type, world, MobsHelper.MARINE_TRADERS_TEXTURES);
    }

    @Override
    protected void func_184651_r() {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        props.setFaction("marine");
        super.func_184651_r();
    }

    @Override
    public boolean canTrade(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        return props.isMarine() || props.isBountyHunter();
    }

    @Override
    public ResourceLocation getTradeTable() {
        return ModLootTables.MARINE_TRADER;
    }

    @Override
    public String getTradeFailMessage() {
        return new TranslationTextComponent(ModI18n.TRADER_NO_PIRATE).getString();
    }

    @Override
    public Currency getCurrency() {
        return Currency.BELLY;
    }
}

