/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.marines;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.cyborg.RadicalBeamWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class PacifistaEntity
extends OPEntity
implements ICommandReceiver {
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    public PacifistaEntity(World world) {
        this((EntityType)ModEntities.PACIFISTA.get(), world);
    }

    public PacifistaEntity(EntityType type, World world) {
        super(type, world);
        if (world != null && !world.field_72995_K) {
            this.getEntityStats().setRace("cyborg");
            this.getEntityStats().setFaction("marine");
            this.getEntityStats().setFightingStyle("brawler");
            MobsHelper.addBasicNPCGoals(this);
            CommandAbility.addCommandGoals((MobEntity)this);
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
            this.field_70714_bg.func_75776_a(2, (Goal)new RadicalBeamWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233826_i_, 20.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233824_g_, 2.0);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(3));
            explosion.doExplosion();
        }
    }

    @Override
    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        IEntityStats props = EntityStatsCapability.get(commandSender);
        if (!props.isMarine()) {
            return false;
        }
        return props.hasMarineRank(FactionHelper.MarineRank.COMMODORE);
    }

    @Override
    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    @Override
    public boolean canMaintainCommand() {
        return this.lastCommandSender == null || !this.lastCommandSender.func_70089_S() || !EntityStatsCapability.get(this.lastCommandSender).isRogue();
    }

    @Override
    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    @Override
    public long getLastCommandTime() {
        return this.lastCommandTime;
    }
}

