/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.BigBombThrowGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PirateBomberEntity
extends AbstractPirateEntity {
    private static final DataParameter<Boolean> HAS_BOMB = EntityDataManager.func_187226_a(PirateBomberEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOMB_FUSE = EntityDataManager.func_187226_a(PirateBomberEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public PirateBomberEntity(EntityType type, World world) {
        super((EntityType<? extends MobEntity>)type, world, MobsHelper.PIRATE_TEXTURES);
        EntityStatsCapability.get((LivingEntity)this).setFightingStyle("swordsman");
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new BigBombThrowGoal(this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, (double)0.225f).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        if (props.isFishman()) {
            this.textures = MobsHelper.PIRATE_FISHMEN_TEXTURES;
            this.chooseTexture();
        }
        this.setDoriki(2000.0 + WyHelper.randomWithRange(0, 1000));
        this.setBelly(5.0 + WyHelper.randomWithRange(0, 10));
        return spawnData;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HAS_BOMB, (Object)true);
        this.func_184212_Q().func_187214_a(BOMB_FUSE, (Object)0);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("hasBomb", this.hasBomb());
        nbt.func_74768_a("bombFuse", this.getBombFuseTime());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setHasBomb(nbt.func_74767_n("hasBomb"));
        this.setBombFuseTime(nbt.func_74762_e("bombFuse"));
    }

    public int getBombFuseTime() {
        return (Integer)this.func_184212_Q().func_187225_a(BOMB_FUSE);
    }

    public boolean isBombFused() {
        return (Integer)this.func_184212_Q().func_187225_a(BOMB_FUSE) > 0;
    }

    public void setBombFuseTime(int time) {
        this.func_184212_Q().func_187227_b(BOMB_FUSE, (Object)time);
    }

    public boolean hasBomb() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_BOMB);
    }

    public void setHasBomb(boolean flag) {
        this.func_184212_Q().func_187227_b(HAS_BOMB, (Object)flag);
    }
}

