/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FindPartnerGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.IGoalPartner;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.RandomWalkingAroundTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.missmerrychristmas.CreateMoleHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.missmerrychristmas.MoleDiggingGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.missmerrychristmas.MoleGrabAndDragGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.missmerrychristmas.MoleHoleJumpGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.Mr4Entity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;

public class MissMerryChristmasEntity
extends OPBossEntity<MissMerryChristmasEntity>
implements IGoalPartner<Mr4Entity> {
    private Mr4Entity partner;
    private Set<BlockPos> holePositions = new HashSet<BlockPos>();
    private NPCPhase<MissMerryChristmasEntity> abovegroundPhase;
    private NPCPhase<MissMerryChristmasEntity> undergroundPhase;
    private MoleHoleJumpGoal moleHoleJumpGoal;

    public MissMerryChristmasEntity(EntityType type, World world) {
        super(type, world);
    }

    public MissMerryChristmasEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.MISS_MERRY_CHRISTMAS.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.abovegroundPhase = new SimplePhase<MissMerryChristmasEntity>("Above Ground Phase", this);
        this.undergroundPhase = new SimplePhase<MissMerryChristmasEntity>("Under Ground Phase", this);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction("pirate");
        this.entityStats.setRace("human");
        this.devilFruitData.setDevilFruit(ModAbilities.MOGU_MOGU_NO_MI);
        this.entityStats.setDoriki(2000.0);
        worldData.addTemporaryCrewMember(ModNPCGroups.BAROQUE_WORKS, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        MobsHelper.addBasicNPCGoals(this);
        this.field_70714_bg.func_75776_a(0, new FindPartnerGoal(this, (EntityType)ModEntities.MR4.get()));
        this.field_70714_bg.func_75776_a(0, (Goal)new MoleDiggingGoal(this));
        this.abovegroundPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.1f, true));
        this.abovegroundPhase.addGoal(3, new ChargedPunchWrapperGoal((MobEntity)this));
        this.undergroundPhase.addGoal(0, new CreateMoleHoleGoal(this));
        this.undergroundPhase.addGoal(1, new RandomWalkingAroundTargetGoal(this, 1.1f, 600, 100));
        this.undergroundPhase.addGoal(3, new MoleGrabAndDragGoal(this));
        this.getPhaseManager().setPhase(this.abovegroundPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.moleHoleJumpGoal = new MoleHoleJumpGoal(this);
            this.undergroundPhase.addGoal(1, this.moleHoleJumpGoal);
        } else {
            this.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.abovegroundPhase.addGoal(2, new SoruWrapperGoal((MobEntity)this));
            this.abovegroundPhase.addGoal(3, new HakaiHoWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.31f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233820_c_, 0.1);
    }

    @Override
    public void func_70071_h_() {
        this.field_70143_R = 0.0f;
        super.func_70071_h_();
    }

    @Override
    public Mr4Entity getPartner() {
        return this.partner;
    }

    @Override
    public void setPartner(Mr4Entity partner) {
        this.partner = partner;
    }

    public void addHole(BlockPos pos) {
        this.holePositions.add(pos);
        AbilityHelper.createFilledCube(this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1, 10, 1, Blocks.field_150350_a, DefaultProtectionRules.CORE_FOLIAGE_ORE);
        System.out.println("New hole at pos: " + pos.toString());
    }

    public Set<BlockPos> getHoles() {
        return this.holePositions;
    }

    public void setUnderGround() {
        System.out.println("Under Ground");
        this.getPhaseManager().setPhase(this.undergroundPhase);
    }

    public void setAboveGround() {
        System.out.println("Above Ground");
        this.getPhaseManager().setPhase(this.abovegroundPhase);
    }

    public boolean isUnderground() {
        return this.getPhaseManager().getCurrentPhase().equals(this.undergroundPhase);
    }

    public boolean isUndergroundStandby() {
        if (!this.isUnderground()) {
            return false;
        }
        return this.moleHoleJumpGoal == null || this.moleHoleJumpGoal.hasTimePassedSinceStart(40.0f);
    }
}

