/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.PartyTableKickCourseAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.supa.AtomicRushAbility;
import xyz.pixelatedw.mineminenomi.abilities.supa.SparklingDaisyAbility;
import xyz.pixelatedw.mineminenomi.abilities.supa.SpiderAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.TakedownKickWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.PartyTableKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.AtomicRushWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SparClawWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SparklingDaisyWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SpiderWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.supa.SpiralHollowWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.mr1.Mr1PhaseSwitcherGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class Mr1Entity
extends OPBossEntity<Mr1Entity> {
    private static final UUID STANDARD_SPIDER_COOLDOWN_BONUS_UUID = UUID.fromString("1f2944fa-fd28-41b9-8f67-392929011bbd");
    private static final AttributeModifier GCD_MOD = new AttributeModifier(UUID.fromString("e478aceb-9865-40da-a137-6359ba503bf0"), "GCD Modifier", -5.0, AttributeModifier.Operation.ADDITION);
    private NPCPhase<Mr1Entity> firstPhase;
    private NPCPhase<Mr1Entity> secondPhase;
    private NPCPhase<Mr1Entity> ultiPhase;
    private SpiderWrapperGoal spiderWrapper;
    private AtomicRushAbility atomicRushAbility;

    public Mr1Entity(EntityType type, World world) {
        super(type, world);
    }

    public Mr1Entity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.MR1.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.firstPhase = new SimplePhase<Mr1Entity>("First Phase", this, this::startFirstPhaseEvent, this::stopFirstPhaseEvent);
        this.secondPhase = new SimplePhase<Mr1Entity>("Second Phase", this, this::startSecondPhaseEvent);
        this.ultiPhase = new SimplePhase<Mr1Entity>("Ultimate Phase", this);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction("pirate");
        this.entityStats.setRace("human");
        this.devilFruitData.setDevilFruit(ModAbilities.SUPA_SUPA_NO_MI);
        worldData.addTemporaryCrewMember(ModNPCGroups.BAROQUE_WORKS, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(4.0);
        this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(6.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        MobsHelper.addBasicNPCGoals(this);
        PartyTableKickCourseWrapperGoal partyTableWrapper = new PartyTableKickCourseWrapperGoal((MobEntity)this);
        this.spiderWrapper = new SpiderWrapperGoal((MobEntity)this);
        ((SpiderAbility)this.spiderWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.addTickEvent((entity, ability) -> {
            if (entity.field_70170_p.func_82737_E() >= ((SpiderAbility)this.spiderWrapper.getAbility()).getLastUseGametime() + 60L && GoalUtil.hasEnoughTargetsAround((MobEntity)entity, 1, 4.0f) && ((PartyTableKickCourseAbility)partyTableWrapper.getAbility()).canUse(entity).isSuccess()) {
                comp.stopContinuity(entity);
                ((PartyTableKickCourseAbility)partyTableWrapper.getAbility()).use(entity);
            }
        }));
        SparklingDaisyWrapperGoal sparklingDaisyWrapper = new SparklingDaisyWrapperGoal((MobEntity)this);
        ((SparklingDaisyAbility)sparklingDaisyWrapper.getAbility()).setProjectilesAmount(this.getChallengeInfo().isDifficultyHard() ? 2 : 1);
        AtomicRushWrapperGoal atomicRushWrapper = new AtomicRushWrapperGoal((MobEntity)this);
        this.atomicRushAbility = (AtomicRushAbility)atomicRushWrapper.getAbility();
        SprintTowardsTargetGoal sprintGoal = new SprintTowardsTargetGoal((MobEntity)this);
        TakedownKickWrapperGoal takedownKickGoal = new TakedownKickWrapperGoal((MobEntity)this);
        SparClawWrapperGoal sparClawGoal = new SparClawWrapperGoal((MobEntity)this);
        SpiralHollowWrapperGoal spiralHollowGoal = new SpiralHollowWrapperGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new Mr1PhaseSwitcherGoal(this));
        this.firstPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.firstPhase.addGoal(1, sprintGoal);
        this.firstPhase.addGoal(2, takedownKickGoal);
        this.firstPhase.addGoal(3, sparClawGoal);
        this.firstPhase.addGoal(3, this.spiderWrapper);
        this.firstPhase.addGoal(3, spiralHollowGoal);
        this.firstPhase.addGoal(4, partyTableWrapper);
        this.secondPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 200.0f, 2.5f));
        this.secondPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.2, true));
        this.secondPhase.addGoal(1, sprintGoal);
        this.secondPhase.addGoal(2, takedownKickGoal);
        this.secondPhase.addGoal(3, sparClawGoal);
        this.secondPhase.addGoal(3, this.spiderWrapper);
        this.secondPhase.addGoal(3, spiralHollowGoal);
        this.secondPhase.addGoal(4, partyTableWrapper);
        this.secondPhase.addGoal(4, sparklingDaisyWrapper);
        this.ultiPhase.addGoal(1, atomicRushWrapper);
        this.getPhaseManager().setPhase(this.firstPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.atomicRushAbility.setDashWaitTime(10);
            ((SpiderAbility)this.spiderWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(STANDARD_SPIDER_COOLDOWN_BONUS_UUID, "Standard Spider Cooldown Bonus", BonusOperation.MUL, 1.75f));
            this.secondPhase.addGoal(3, new HakaiHoWrapperGoal((MobEntity)this));
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(5.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(5.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(8.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(400.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            HakaiHoWrapperGoal hakaiHoWrapper = new HakaiHoWrapperGoal((MobEntity)this);
            ((HakaiHoAbility)hakaiHoWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 60.0f));
            ShiganWrapperGoal shiganWrapper = new ShiganWrapperGoal((MobEntity)this);
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.firstPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 200.0f, 2.5f));
            this.firstPhase.addGoal(3, hakaiHoWrapper);
            this.firstPhase.addGoal(3, shiganWrapper);
            this.firstPhase.addGoal(3, new RankyakuWrapperGoal((MobEntity)this));
            this.secondPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 150.0f, 2.5f));
            this.secondPhase.addGoal(3, hakaiHoWrapper);
            this.secondPhase.addGoal(3, shiganWrapper);
            this.secondPhase.addGoal(3, new RankyakuWrapperGoal((MobEntity)this));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233826_i_, 4.0).func_233815_a_(Attributes.field_233827_j_, 2.0).func_233815_a_(Attributes.field_233820_c_, 0.8);
    }

    public void startUltiPhase() {
        this.getPhaseManager().setPhase(this.ultiPhase);
    }

    public void startSecondPhase() {
        this.getPhaseManager().setPhase(this.secondPhase);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            boolean canSee = this.func_70685_l((Entity)this.func_70638_az());
            double yDiff = Math.abs(this.func_226278_cu_() - this.func_70638_az().func_226278_cu_());
            if (yDiff > 20.0 && !canSee) {
                BlockPos tpPos = WyHelper.findValidGroundLocation((Entity)this, this.func_70638_az().func_233580_cy_(), 10, 10);
                this.func_223102_j(tpPos.func_177958_n(), tpPos.func_177956_o() + 5, tpPos.func_177952_p());
            }
        }
    }

    public void func_226292_a_(Hand hand, boolean updateSelf) {
        if (this.func_70638_az() != null) {
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)this.field_70170_p, this.func_70638_az().func_226277_ct_(), this.func_70638_az().func_226278_cu_() + (double)this.func_70638_az().func_70047_e(), this.func_70638_az().func_226281_cx_());
            this.field_70170_p.func_184133_a(null, this.func_70638_az().func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        super.func_226292_a_(hand, updateSelf);
    }

    public boolean isUltiAvailable() {
        return this.atomicRushAbility.getComponent(ModAbilityKeys.COOLDOWN).map(CooldownComponent::isOnCooldown).orElse(true) == false;
    }

    public double getUltiTicks() {
        return this.atomicRushAbility.getComponent(ModAbilityKeys.CONTINUOUS).map(ContinuousComponent::getThresholdTime).orElse(Float.valueOf(-1.0f)).floatValue();
    }

    private void startFirstPhaseEvent(Mr1Entity entity) {
        if (this.isDifficultyHardOrAbove()) {
            ((SpiderAbility)this.spiderWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(STANDARD_SPIDER_COOLDOWN_BONUS_UUID, "Standard Spider Cooldown Bonus", BonusOperation.MUL, 1.5f));
        }
    }

    private void stopFirstPhaseEvent(Mr1Entity entity) {
        if (this.isDifficultyHardOrAbove()) {
            ((SpiderAbility)this.spiderWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().removeBonus(STANDARD_SPIDER_COOLDOWN_BONUS_UUID));
        }
    }

    private void startSecondPhaseEvent(Mr1Entity entity) {
        ModifiableAttributeInstance attr;
        if (this.isDifficultyHardOrAbove() && (attr = entity.func_110148_a((Attribute)ModAttributes.GCD.get())) != null && !attr.func_180374_a(GCD_MOD)) {
            attr.func_233767_b_(GCD_MOD);
        }
    }
}

