/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.bomu.BreezeBreathBombAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.FindPartnerGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.IGoalPartner;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.MeleeRangedStyleSwitchGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.BreezeBreathBombWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.ExplosionImmunityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.ExplosivePunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.KickBombWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.bomu.NoseFancyCannonWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.baroqueworks.MissValentineEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.ModGunItem;

public class Mr5Entity
extends OPBossEntity<Mr5Entity>
implements IRangedAttackMob,
IGoalPartner<MissValentineEntity> {
    private static final UUID HARD_BREEZE_BREATH_COOLDOWN_BONUS = UUID.fromString("f417a4af-840f-4f69-86f4-c44a15da5e9a");
    private static final int PAUSE_TICKS_AFTER_NOSE_FANCY = 40;
    private MissValentineEntity partner;
    private boolean lostGun;
    private NoseFancyCannonWrapperGoal noseFancyCannonWrapper;
    private BreezeBreathBombWrapperGoal breezeBreathBombWrapper;
    private NPCPhase<Mr5Entity> meleePhase;
    private NPCPhase<Mr5Entity> rangePhase;

    public Mr5Entity(EntityType type, World world) {
        super(type, world);
    }

    public Mr5Entity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.MR5.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.meleePhase = new SimplePhase<Mr5Entity>("Melee Phase", this);
        this.rangePhase = new SimplePhase<Mr5Entity>("Range Phase", this);
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction("pirate");
        this.entityStats.setRace("human");
        this.devilFruitData.setDevilFruit(ModAbilities.BOMU_BOMU_NO_MI);
        this.entityStats.setDoriki(2000.0);
        worldData.addTemporaryCrewMember(ModNPCGroups.BAROQUE_WORKS, (LivingEntity)this);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        boolean isStandard = this.getChallengeInfo().isDifficultyStandard();
        MobsHelper.addBasicNPCGoals(this);
        this.noseFancyCannonWrapper = new NoseFancyCannonWrapperGoal((MobEntity)this);
        this.breezeBreathBombWrapper = new BreezeBreathBombWrapperGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, new FindPartnerGoal(this, (EntityType)ModEntities.MISS_VALENTINE.get()));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeRangedStyleSwitchGoal((MobEntity)this).forceMeleeEmptyHanded().addStyleSwitchEvent(100, this::onStyleSwitched));
        this.field_70714_bg.func_75776_a(0, (Goal)new ExplosionImmunityWrapperGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)this.noseFancyCannonWrapper);
        this.rangePhase.addGoal(3, this.breezeBreathBombWrapper);
        this.meleePhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 0.95f, true).setEarlyStop(this::isInRangeForAbilities));
        this.meleePhase.addGoal(3, new KickBombWrapperGoal((MobEntity)this));
        this.meleePhase.addGoal(3, new ExplosivePunchWrapperGoal((MobEntity)this));
        this.getPhaseManager().setPhase(this.rangePhase);
        this.spawnGunIfPossible();
        if (isStandard) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.rangePhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 150.0f, 2.5f));
            this.rangePhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 80.0f, 5.0f));
            this.rangePhase.addGoal(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 40, 50.0f));
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(3.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(400.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(12.0);
            ((BreezeBreathBombAbility)this.breezeBreathBombWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_BREEZE_BREATH_COOLDOWN_BONUS, "Hard Difficulty Breeze Breath Bonus", BonusOperation.ADD, -140.0f));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.rangePhase.addGoal(0, new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.rangePhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 100.0f, 2.5f));
            this.rangePhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 40.0f, 5.0f));
            this.rangePhase.addGoal(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 20, 50.0f));
            this.meleePhase.addGoal(0, new BusoshokuHakiHardeningWrapperGoal((MobEntity)this));
            this.meleePhase.addGoal(3, new HakaiHoWrapperGoal((MobEntity)this));
            this.meleePhase.addGoal(3, new ShiganWrapperGoal((MobEntity)this));
        }
    }

    private void spawnGunIfPossible() {
        if (this.lostGun) {
            return;
        }
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.FLINTLOCK.get()));
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.WALKER.get()));
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModWeapons.WALKER.get()));
        }
    }

    private boolean isInRangePhase() {
        return this.getPhaseManager().getCurrentPhase().equals(this.rangePhase);
    }

    public void func_184201_a(EquipmentSlotType slot, ItemStack stack) {
        if (!this.field_70170_p.func_201670_d() && (stack == null || stack.func_190926_b()) && this.isInRangePhase()) {
            this.lostGun = true;
        }
        super.func_184201_a(slot, stack);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233820_c_, 0.2).func_233815_a_(Attributes.field_233826_i_, 4.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            boolean canSee = this.func_70685_l((Entity)this.func_70638_az());
            double yDiff = Math.abs(this.func_226278_cu_() - this.func_70638_az().func_226278_cu_());
            if (yDiff > 5.0 && !canSee && !this.breezeBreathBombWrapper.isForced()) {
                ((BreezeBreathBombAbility)this.breezeBreathBombWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.stopCooldown((LivingEntity)this));
                this.breezeBreathBombWrapper.forceUse();
            }
        }
    }

    private void onStyleSwitched(LivingEntity entity, boolean isRanged) {
        if (isRanged) {
            this.getPhaseManager().setPhase(this.rangePhase);
            this.spawnGunIfPossible();
        } else {
            this.getPhaseManager().setPhase(this.meleePhase);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            if (this.getChallengeInfo().isDifficultyHard()) {
                this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
            }
        }
    }

    public void func_82196_d(LivingEntity target, float distance) {
        ItemStack heldItem = this.func_184614_ca();
        if (heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof ModGunItem)) {
            return;
        }
        if (!this.noseFancyCannonWrapper.hasTimePassedSinceLastEnd(40.0f)) {
            return;
        }
        if (target == null || !target.func_70089_S() || AbilityHelper.isInCreativeOrSpectator(target)) {
            return;
        }
        AbilityProjectileEntity bullet = new NormalBulletProjectile(this.field_70170_p, (LivingEntity)this);
        float damage = 8.0f;
        float speed = 2.0f;
        if (this.getChallengeInfo().isDifficultyHard()) {
            bullet = new KairosekiBulletProjectile(this.field_70170_p, (LivingEntity)this);
            damage = 10.0f;
            speed = 2.5f;
        }
        bullet.setDamage(damage);
        this.field_70170_p.func_217376_c((Entity)bullet);
        bullet.func_234612_a_((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, speed, 0.0f);
    }

    private boolean isInRangeForAbilities() {
        if (!GoalUtil.hasAliveTarget((MobEntity)this)) {
            return true;
        }
        return Math.abs(this.func_70032_d((Entity)this.func_70638_az())) < 30.0f;
    }

    @Override
    public MissValentineEntity getPartner() {
        return this.partner;
    }

    @Override
    public void setPartner(MissValentineEntity partner) {
        this.partner = partner;
    }
}

