/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.blackcatpirates;

import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.ShakushiAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.RankyakuAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.SoruAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.DeadzoneRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.GankingRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.PhysicalHitRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.RevengeMeter;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.TargetRunningAwayRevengeCheck;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.ShakushiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.StealthFootWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.TakedownKickWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.AntiMannerKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.GeppoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KuroEntity
extends OPBossEntity<KuroEntity> {
    private static final UUID SHAKUSHI_RANGE_BONUS_UUID = UUID.fromString("80e205c9-4fc8-4fed-97ad-f3d8cec36bd6");
    private static final UUID HARD_SORU_COOLDOWN_BONUS_UUID = UUID.fromString("600830a0-5796-489b-892e-45432d273d29");
    private RevengeMeter revengeMeter;
    private NPCPhase<KuroEntity> normalPhase;
    private NPCPhase<KuroEntity> ultiPhase;
    private ShakushiWrapperGoal shakushiWrapper;

    public KuroEntity(EntityType type, World world) {
        super(type, world);
    }

    public KuroEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.KURO.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.revengeMeter = new RevengeMeter((LivingEntity)this, 100, 1);
        this.normalPhase = new SimplePhase<KuroEntity>("Normal Phase", this);
        this.ultiPhase = new SimplePhase<KuroEntity>("Ulti Phase", this);
        this.entityStats.setFaction("pirate");
        this.entityStats.setRace("human");
        this.entityStats.setFightingStyle("swordsman");
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.addTemporaryCrewMember(ModNPCGroups.BLACK_CAT_PIRATES, (LivingEntity)this);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.CAT_CLAWS.get()));
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModWeapons.CAT_CLAWS.get()));
        this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.1);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.0);
        this.getRevengeMeter().addCheck(new DeadzoneRevengeCheck(3));
        this.getRevengeMeter().addCheck(new GankingRevengeCheck(10, 5.0f));
        this.shakushiWrapper = new ShakushiWrapperGoal((MobEntity)this);
        ((ShakushiAbility)this.shakushiWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.addStartEvent((e, a) -> {
            if (this.ultiPhase.isActive(this) && comp.isOnCooldown()) {
                this.getPhaseManager().setPhase(this.normalPhase);
            }
        }));
        ((ShakushiAbility)this.shakushiWrapper.getAbility()).getComponent(ModAbilityKeys.RANGE).ifPresent(comp -> comp.getBonusManager().addBonus(SHAKUSHI_RANGE_BONUS_UUID, "Shakushi Range Bonus", BonusOperation.ADD, 40.0f));
        MobsHelper.addBasicNPCGoals(this);
        this.normalPhase.addGoal(0, new SprintTowardsTargetGoal((MobEntity)this));
        this.normalPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 300.0f, 2.5f));
        this.normalPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 350.0f, 3.0f));
        this.normalPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.normalPhase.addGoal(2, new TakedownKickWrapperGoal((MobEntity)this));
        this.normalPhase.addGoal(2, new StealthFootWrapperGoal((MobEntity)this));
        this.ultiPhase.addGoal(0, this.shakushiWrapper);
        this.getPhaseManager().setPhase(this.normalPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(2.0);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(3.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(6.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(300.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(3.5);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(14.0);
            this.func_110148_a(Attributes.field_233825_h_).func_111128_a(6.0);
            this.getRevengeMeter().addCheck(new PhysicalHitRevengeCheck(2));
            this.getRevengeMeter().addCheck(new TargetRunningAwayRevengeCheck(5, 10.0f));
            RankyakuWrapperGoal rankyakuWrapper = new RankyakuWrapperGoal((MobEntity)this);
            ((RankyakuAbility)rankyakuWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 100.0f));
            SoruWrapperGoal soruWrapper = new SoruWrapperGoal((MobEntity)this);
            ((SoruAbility)soruWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(HARD_SORU_COOLDOWN_BONUS_UUID, "Hard Soru Cooldown Bonus", BonusOperation.MUL, 0.5f));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(1, new GeppoWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(2, new AntiMannerKickCourseWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(2, new SoruWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(2, new KamieWrapperGoal((MobEntity)this));
            this.normalPhase.addGoal(3, rankyakuWrapper);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.31f).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.15).func_233815_a_(Attributes.field_233825_h_, 5.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.getRevengeMeter().tick();
            boolean isUltiAvailable = ((ShakushiAbility)this.shakushiWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).map(comp -> comp.isOnCooldown()).orElse(false);
            if (this.normalPhase.isActive(this) && !isUltiAvailable && (this.getRevengeMeter().isRevengeMaxed() || (double)this.func_110143_aJ() <= WyHelper.percentage(20.0, this.func_110138_aP()))) {
                this.getPhaseManager().setPhase(this.ultiPhase);
                this.getRevengeMeter().setRevengeValue(0);
            }
        }
    }

    @Override
    public RevengeMeter getRevengeMeter() {
        return this.revengeMeter;
    }
}

