/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates;

import com.google.common.collect.Iterables;
import java.util.UUID;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.pixelatedw.mineminenomi.abilities.BakudanAbility;
import xyz.pixelatedw.mineminenomi.abilities.MH5Ability;
import xyz.pixelatedw.mineminenomi.abilities.sniper.KaenBoshiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.BakudanWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.ChargedCleaveWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.GunArrayWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.MH5WrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.SlamWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.WootzNetLauncherWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KaenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.donkrieg.DonKriegPhaseSwitcherGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.donkrieg.MH5PhaseGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

public class DonKriegEntity
extends OPBossEntity<DonKriegEntity> {
    private static final UUID STANDARD_BAKUDAN_COOLDOWN_BONUS_UUID = UUID.fromString("5eeb8a76-d0d9-4fdd-816d-7a8ff4e903ad");
    private static final UUID STANDARD_KAEN_HOSHA_COOLDOWN_BONUS_UUID = UUID.fromString("6445513d-f018-42db-9be5-4f3f08037a50");
    private static final AttributeModifier GCD_MOD = new AttributeModifier(UUID.fromString("e478aceb-9865-40da-a137-6359ba503bf0"), "GCD Modifier", -5.0, AttributeModifier.Operation.ADDITION);
    private final NPCPhase<DonKriegEntity> fistPhase = new SimplePhase<DonKriegEntity>("Fist Phase", this);
    private final NPCPhase<DonKriegEntity> daisensoPhase = new SimplePhase<DonKriegEntity>("Daisenso Phase", this, this::startDaisensoPhaseEvent);
    private final NPCPhase<DonKriegEntity> mh5Phase = new SimplePhase<DonKriegEntity>("MH5 Phase", this, this::startMH5PhaseEvent);
    private final NonNullList<ItemStack> bulletsStash = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> netsStash = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);

    public DonKriegEntity(EntityType type, World world) {
        super(type, world);
    }

    public DonKriegEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.DON_KRIEG.get(), challenge);
    }

    @Override
    public void initBoss() {
        this.entityStats.setFaction("pirate");
        this.entityStats.setRace("human");
        this.entityStats.setFightingStyle("brawler");
        ExtendedWorldData worldData = ExtendedWorldData.get();
        worldData.addTemporaryCrewMember(ModNPCGroups.KRIEG_PIRATES, (LivingEntity)this);
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModArmors.WOOTZ_STEEL_ARMOR.get()));
        this.func_110148_a((Attribute)ModAttributes.ATTACK_RANGE.get()).func_111128_a(1.1);
        this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
        this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(1.5);
        SprintTowardsTargetGoal sprintGoal = new SprintTowardsTargetGoal((MobEntity)this);
        BakudanWrapperGoal bakudanWrapper = new BakudanWrapperGoal((MobEntity)this);
        ((BakudanAbility)bakudanWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, 100.0f));
        MH5WrapperGoal mh5Wrapper = new MH5WrapperGoal((MobEntity)this);
        ImprovedMeleeAttackGoal meleeAttackGoal = new ImprovedMeleeAttackGoal(this, 1.0, true);
        meleeAttackGoal.setEarlyStop(() -> ((MH5Ability)mh5Wrapper.getAbility()).isCharging());
        GunArrayWrapperGoal gunArrayWrapper = new GunArrayWrapperGoal((MobEntity)this);
        KaenBoshiWrapperGoal kaenBoshiWrapper = new KaenBoshiWrapperGoal((MobEntity)this);
        ((KaenBoshiAbility)kaenBoshiWrapper.getAbility()).getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.addStartEvent((entity, ability) -> ((KaenBoshiAbility)kaenBoshiWrapper.getAbility()).shoot(entity, ability)));
        WootzNetLauncherWrapperGoal wootzNetLauncherWrapper = new WootzNetLauncherWrapperGoal((MobEntity)this);
        MobsHelper.addBasicNPCGoals(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new DonKriegPhaseSwitcherGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MH5PhaseGoal(this));
        this.fistPhase.addGoal(1, (Goal)meleeAttackGoal);
        this.fistPhase.addGoal(1, sprintGoal);
        this.fistPhase.addGoal(3, new ChargedPunchWrapperGoal((MobEntity)this));
        this.fistPhase.addGoal(3, bakudanWrapper);
        this.daisensoPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 350.0f, 2.5f));
        this.daisensoPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 350.0f, 2.5f));
        this.daisensoPhase.addGoal(1, (Goal)meleeAttackGoal);
        this.daisensoPhase.addGoal(1, sprintGoal);
        this.daisensoPhase.addGoal(1, wootzNetLauncherWrapper);
        this.daisensoPhase.addGoal(2, gunArrayWrapper);
        this.daisensoPhase.addGoal(2, kaenBoshiWrapper);
        this.daisensoPhase.addGoal(3, new ChargedCleaveWrapperGoal((MobEntity)this));
        this.daisensoPhase.addGoal(3, bakudanWrapper);
        this.mh5Phase.addGoal(1, mh5Wrapper);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(2000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
            this.fillBulletStash((Item)ModItems.BULLET.get());
            this.fillNetStash((Item)ModItems.ROPE_NET.get());
            ((BakudanAbility)bakudanWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(STANDARD_BAKUDAN_COOLDOWN_BONUS_UUID, "Standard Bakudan Cooldown Bonus", BonusOperation.MUL, 2.0f));
            ((KaenBoshiAbility)kaenBoshiWrapper.getAbility()).getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.getBonusManager().addBonus(STANDARD_KAEN_HOSHA_COOLDOWN_BONUS_UUID, "Standard Kaen Hosha Cooldown Bonus", BonusOperation.MUL, 2.0f));
            this.getPhaseManager().setPhase(this.fistPhase);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(400.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(8.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(16.0);
            this.fillBulletStash((Item)ModItems.KAIROSEKI_BULLET.get());
            this.fillNetStash((Item)ModItems.KAIROSEKI_NET.get());
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.fistPhase.addGoal(0, new BusoshokuHakiHardeningWrapperGoal((MobEntity)this));
            this.fistPhase.addGoal(3, new HakaiHoWrapperGoal((MobEntity)this));
            this.fistPhase.addGoal(3, new JishinHoWrapperGoal((MobEntity)this));
            this.daisensoPhase.addGoal(0, new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.daisensoPhase.addGoal(3, new JishinHoWrapperGoal((MobEntity)this));
            this.daisensoPhase.addGoal(3, new SlamWrapperGoal((MobEntity)this));
            this.mh5Phase.addGoal(0, new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
            this.mh5Phase.addGoal(0, new KamieWrapperGoal((MobEntity)this));
            this.getPhaseManager().setPhase(this.daisensoPhase);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 10.0).func_233815_a_(Attributes.field_233820_c_, 0.9).func_233815_a_(Attributes.field_233824_g_, 1.0);
    }

    private void fillBulletStash(Item bulletType) {
        System.out.println("@@@");
        for (int i = 0; i < this.bulletsStash.size(); ++i) {
            ItemStack newStack = bulletType.func_190903_i();
            newStack.func_190920_e(1);
            this.bulletsStash.set(i, (Object)newStack);
        }
    }

    private void fillNetStash(Item netType) {
        for (int i = 0; i < this.netsStash.size(); ++i) {
            ItemStack newStack = netType.func_190903_i();
            newStack.func_190920_e(64);
            this.netsStash.set(i, (Object)newStack);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public Iterable<ItemStack> func_184209_aF() {
        return Iterables.concat((Iterable)super.func_184209_aF(), this.bulletsStash, this.netsStash);
    }

    public void startDaisensoPhase() {
        this.getPhaseManager().setPhase(this.daisensoPhase);
        MH5Ability mh5Ability = this.abilityData.getEquippedAbility(MH5Ability.INSTANCE);
        if (mh5Ability != null) {
            int startCooldown = this.isDifficultyHardOrAbove() ? 800 : 400;
            mh5Ability.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(comp -> comp.startCooldown((LivingEntity)this, startCooldown));
        }
    }

    public void startMH5Phase() {
        this.getPhaseManager().setPhase(this.mh5Phase);
    }

    public boolean hasFistPhaseActive() {
        return this.fistPhase.isActive(this);
    }

    public boolean hasDaisensoPhaseActive() {
        return this.daisensoPhase.isActive(this);
    }

    public boolean hasMH5PhaseActive() {
        return this.mh5Phase.isActive(this);
    }

    private void startDaisensoPhaseEvent(DonKriegEntity entity) {
        ModifiableAttributeInstance attr;
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.DAISENSO.get()));
        if (this.isDifficultyHardOrAbove() && (attr = entity.func_110148_a((Attribute)ModAttributes.GCD.get())) != null && !attr.func_180374_a(GCD_MOD)) {
            attr.func_233767_b_(GCD_MOD);
        }
    }

    private void startMH5PhaseEvent(DonKriegEntity entity) {
        this.func_184201_a(EquipmentSlotType.HEAD, ((Item)ModArmors.MH5_GAS_MASK.get()).func_190903_i());
        this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
    }
}

