/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhaseManager;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.MeleeRangedStyleSwitchGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KaenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KemuriBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.NemuriBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.RenpatsuNamariBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.SakuretsuSabotenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TetsuBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TokuyoAburaBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SniperTrainerEntity
extends TrainerEntity
implements IHakiTrainer,
IRangedAttackMob {
    private final NPCPhaseManager phaseManager = new NPCPhaseManager((MobEntity)this);
    private NPCPhase<SniperTrainerEntity> meleePhase;
    private NPCPhase<SniperTrainerEntity> rangePhase;

    public SniperTrainerEntity(EntityType type, World world) {
        super(type, world, MobsHelper.SNIPER_TRAINER_TEXTURES);
        if (world != null && !world.field_72995_K) {
            this.meleePhase = new SimplePhase<SniperTrainerEntity>("Melee Phase", this);
            this.rangePhase = new SimplePhase<SniperTrainerEntity>("Range Phase", this);
            this.getEntityStats().setFaction("civilian");
            this.getEntityStats().setFightingStyle("sniper");
            this.getEntityStats().setRace("human");
            ItemStack randomSword = new ItemStack((IItemProvider)Items.field_151031_f);
            this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
            this.setDoriki(2000.0 + WyHelper.randomWithRange(0, 1000));
            this.setBelly(20.0 + WyHelper.randomWithRange(0, 20));
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(12.0);
            this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true, true));
            this.field_70714_bg.func_75776_a(0, (Goal)new MeleeRangedStyleSwitchGoal((MobEntity)this).forceMeleeEmptyHanded().addStyleSwitchEvent(100, this::onStyleSwitched));
            this.meleePhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.15, true));
            this.meleePhase.addGoal(1, new DashDodgeTargetGoal((MobEntity)this, 40.0f, 6.0f));
            this.rangePhase.addGoal(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 60, 120.0f));
            WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
            goals.addEntry(() -> new KaenBoshiWrapperGoal((MobEntity)this, 20), 3.0f);
            goals.addEntry(() -> new SakuretsuSabotenBoshiWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new TokuyoAburaBoshiWrapperGoal((MobEntity)this, 20), 3.0f);
            goals.addEntry(() -> new TetsuBoshiWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new RenpatsuNamariBoshiWrapperGoal((MobEntity)this, 60), 2.0f);
            goals.addEntry(() -> new KemuriBoshiWrapperGoal((MobEntity)this), 1.0f);
            goals.addEntry(() -> new NemuriBoshiWrapperGoal((MobEntity)this, 60), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, 5, goals).forEach(goal -> this.rangePhase.addGoal(2, (Goal)goal));
            MobsHelper.addBusoshokuHaki((MobEntity)this, 100);
            this.phaseManager.setPhase(this.rangePhase);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.28f).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233826_i_, 15.0);
    }

    private void onStyleSwitched(LivingEntity entity, boolean isRanged) {
        if (isRanged) {
            this.phaseManager.setPhase(this.rangePhase);
        } else {
            this.phaseManager.setPhase(this.meleePhase);
        }
    }

    @Override
    public void func_70619_bc() {
        this.phaseManager.tick();
    }

    public void func_82196_d(LivingEntity target, float velocity) {
        if (this.func_184614_ca() == null || !this.func_184614_ca().func_77973_b().equals(Items.field_151031_f)) {
            return;
        }
        AbilityProjectileEntity proj = new NormalBulletProjectile(this.field_70170_p, (LivingEntity)this);
        proj.setDamage(5.0f);
        if (this.isAboveNormalDifficulty()) {
            proj = new KairosekiBulletProjectile(this.field_70170_p, (LivingEntity)this);
            proj.setDamage(7.0f);
        }
        proj.func_234612_a_((Entity)this, this.field_70125_A, this.field_70177_z, 0.0f, 2.0f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)proj);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    @Override
    public List<QuestId> getAvailableQuests(PlayerEntity player) {
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        ArrayList<QuestId> availableQuests = new ArrayList<QuestId>();
        if (entityProps.isSniper()) {
            availableQuests.addAll(ModQuests.SNIPER_TRIALS.stream().map(reg -> reg).collect(Collectors.toList()));
        }
        return availableQuests;
    }

    @Override
    public HakiType getTrainingHaki() {
        return HakiType.BUSOSHOKU;
    }
}

