/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.doku;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import xyz.pixelatedw.mineminenomi.abilities.doku.ChloroBallAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.DokuHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.DokuProjectiles;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.EntityCloud;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ChloroBallProjectile
extends AbilityProjectileEntity
implements IEntityAdditionalSpawnData {
    private boolean isDemonMode = false;
    private int spread = 4;

    public ChloroBallProjectile(EntityType type, World world) {
        super(type, world);
    }

    public ChloroBallProjectile(World world, LivingEntity player, boolean isDemonForm) {
        super((EntityType)DokuProjectiles.CHLORO_BALL.get(), world, player, ChloroBallAbility.INSTANCE);
        this.setDamage(isDemonForm ? 12.0f : 7.0f);
        this.isDemonMode = isDemonForm;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 300, this.getPoisonAmplifier()));
        this.onBlockImpactEvent.onImpact(hitEntity.func_233580_cy_());
    }

    private void onBlockImpactEvent(BlockPos pos) {
        int fails = 0;
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        int i = 0;
        while (i < this.getPoisonBlockAmount() && fails <= 100) {
            double offsetX = WyHelper.randomWithRange(-this.spread, this.spread);
            double offsetY = WyHelper.randomWithRange(-2, 2);
            double offsetZ = WyHelper.randomWithRange(-this.spread, this.spread);
            mutpos.func_189532_c(this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            if (this.field_70170_p.func_180495_p(mutpos.func_177977_b()).func_185904_a().func_76220_a() && AbilityHelper.placeBlockIfAllowed(this.getThrower(), (BlockPos)mutpos, this.getPoisonBlock().func_176223_P(), DefaultProtectionRules.AIR_FOLIAGE)) {
                ++i;
                continue;
            }
            ++fails;
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHLORO_BALL.get(), (Entity)this, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
        ChloroBallCloudEntity smokeCloud = new ChloroBallCloudEntity(this, this.field_70170_p);
        smokeCloud.setLife(30);
        smokeCloud.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0f, 0.0f);
        smokeCloud.func_213293_j(0.0, 0.0, 0.0);
        smokeCloud.setThrower(this.getThrower());
        this.field_70170_p.func_217376_c((Entity)smokeCloud);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70027_ad()) {
                ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, this.func_233580_cy_().func_177958_n(), this.func_233580_cy_().func_177956_o(), this.func_233580_cy_().func_177952_p(), 4.0f);
                explosion.setStaticDamage(20.0f);
                explosion.setDestroyBlocks(false);
                explosion.setFireAfterExplosion(false);
                explosion.setExplosionSound(true);
                explosion.setSmokeParticles(new CommonExplosionParticleEffect(3));
                explosion.doExplosion();
                this.spread = 8;
                this.onBlockImpactEvent.onImpact(this.func_233580_cy_());
                return;
            }
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.DOKU.get());
                if (this.isDemonMode) {
                    data.setColor(1.0f, 0.0f, 0.0f);
                }
                data.setLife(5);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }

    public ParticleEffect.Details getPoisonParticles() {
        return this.isDemonMode ? DokuHelper.DETAILS : ParticleEffect.EMPTY_DETAILS;
    }

    public int getPoisonAmplifier() {
        return this.isDemonMode ? 4 : 0;
    }

    public int getPoisonBlockAmount() {
        return this.isDemonMode ? 40 : 20;
    }

    public Block getPoisonBlock() {
        return this.isDemonMode ? (Block)ModBlocks.DEMON_POISON.get() : (Block)ModBlocks.POISON.get();
    }

    public int getPoisonRange() {
        return this.isDemonMode ? 5 : 8;
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.isDemonMode);
    }

    @Override
    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.isDemonMode = buffer.readBoolean();
    }

    public boolean isDemonMode() {
        return this.isDemonMode;
    }

    public static class ChloroBallCloudEntity
    extends EntityCloud {
        private ChloroBallProjectile proj;

        public ChloroBallCloudEntity(ChloroBallProjectile proj, World world) {
            super(world);
            this.proj = proj;
        }

        public ChloroBallCloudEntity(World world) {
            super(world);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                for (LivingEntity target : WyHelper.getNearbyLiving(this.func_213303_ch(), (IWorld)this.field_70170_p, this.proj.getPoisonRange(), ModEntityPredicates.getEnemyFactions(this.getThrower()))) {
                    if (this.getThrower() == target || target.func_70644_a((Effect)ModEffects.DOKU_POISON.get())) continue;
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.DOKU_POISON.get(), 200, this.proj.getPoisonAmplifier()));
                }
                if (this.field_70173_aa % 2 == 0) {
                    WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHLORO_BALL_CLOUD.get(), this, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), this.proj.getPoisonParticles());
                }
            }
        }
    }
}

