/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.gasu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.gasu.ShinokuniAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.GasuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GasRobeProjectile
extends AbilityProjectileEntity {
    private boolean hasShinokuniEnabled = false;
    private ShinokuniAbility shinokuniAbility;

    public GasRobeProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GasRobeProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)GasuProjectiles.GAS_ROBE.get(), world, player, ability);
        this.setDamage(0.1f);
        this.setMaxLife(30);
        this.setPassThroughEntities();
        this.setArmorPiercing(0.5f);
        this.hasShinokuniEnabled = ((MorphInfo)ModMorphs.SHINOKUNI.get()).isActive(player);
        if (this.hasShinokuniEnabled) {
            this.shinokuniAbility = AbilityDataCapability.get(player).getEquippedAbility(ShinokuniAbility.INSTANCE);
        } else {
            this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_76437_t, 200, 2), new EffectInstance(Effects.field_76440_q, 40, 0), new EffectInstance(Effects.field_76436_u, 200, 6)};
        }
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        if (this.hasShinokuniEnabled) {
            this.shinokuniAbility.applyEffects(this.getThrower(), entity);
        }
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GAS_ROBE.get(), (Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }
}

