/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.gasu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.gasu.GastilleAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.GasuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GastilleProjectile
extends AbilityProjectileEntity {
    public GastilleProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GastilleProjectile(World world, LivingEntity player) {
        super((EntityType)GasuProjectiles.GASTILLE.get(), world, player, GastilleAbility.INSTANCE);
        this.setDamage(50.0f);
        this.setPassThroughEntities();
        this.setCanGetStuckInGround();
        this.setArmorPiercing(0.5f);
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_76436_u, 200, 3)};
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 5.0f);
        explosion.setStaticDamage(28.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(5));
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.GASTILLE.get(), (Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }
}

