/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.goro;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.GoroProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateLightningEntity;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.LightningExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class LightningEntity
extends AbilityProjectileEntity {
    private float length = 0.0f;
    private float size = 0.01f;
    private int branches = 5;
    private int segments = 7;
    private int color = 16641300;
    private int alpha = 77;
    private int angle = 50;
    private boolean mimicVanilla = true;
    private boolean lightningMovement = true;
    private boolean energyEffect = true;
    private final LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, this.field_70170_p);
    public long seed;
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Long> contactBlocks = new ArrayList<Long>();
    public List<BlockPos> firstContactBlocks = new ArrayList<BlockPos>();
    public List<Integer> targets = new ArrayList<Integer>();
    public ArrayList<Entity> explosionTargets = new ArrayList();
    private int explosionSize = 0;
    private float explosionBlockResistance = 0.1f;
    private boolean explosionDestroysBlocks = true;
    private boolean firstTick = true;
    private boolean hasToCheckForTarget = true;
    private boolean canCauseKnockback = true;
    private double boxSizeDivision = 0.1;
    private int targetTimeToReset = 20;
    private float travelSpeed = 12.0f;
    private float travelLength = 0.0f;
    private BlockPos finalPos;

    public LightningEntity(EntityType<Entity> entityType, World world) {
        super(entityType, world);
        this.field_70158_ak = true;
        this.seed = this.field_70146_Z.nextLong();
        this.entities = new ArrayList<Entity>();
        this.firstContactBlocks = new ArrayList<BlockPos>();
        this.contactBlocks = new ArrayList<Long>();
        this.targets = new ArrayList<Integer>();
    }

    public LightningEntity(Entity thrower, float travelLength, float travelSpeed, @Nullable AbilityCore<? extends IAbility> ability) {
        this(thrower, thrower.func_226277_ct_(), thrower.func_226280_cw_(), thrower.func_226281_cx_(), thrower.field_70177_z, thrower.field_70125_A, travelLength, travelSpeed, ability);
    }

    public LightningEntity(Entity thrower, double posX, double posY, double posZ, float rotationYaw, float rotationPitch, float travelLength, float travelSpeed, @Nullable AbilityCore<? extends IAbility> abilityCore) {
        super((EntityType)GoroProjectiles.LIGHTNING.get(), thrower.field_70170_p, thrower instanceof AbilityProjectileEntity ? ((AbilityProjectileEntity)thrower).getThrower() : (LivingEntity)thrower, abilityCore);
        super.func_70012_b(posX, posY, posZ, rotationYaw, rotationPitch);
        this.setLength(2.0f);
        this.entityDamaged = true;
        this.travelLength = travelLength;
        this.travelSpeed = travelSpeed;
        super.setNoVelocityRotation();
        super.setArmorPiercing(0.75f);
        super.setRemoveOnBlockLimit(false);
    }

    public void onEntityImpactEvent(Entity hitEntity) {
        if (this.targets.contains(hitEntity.getEntity().func_145782_y()) || hitEntity.func_145782_y() == super.func_145782_y()) {
            return;
        }
        if (this.hasToCheckForTarget) {
            this.targets.add(hitEntity.getEntity().func_145782_y());
        }
        if (super.getDamage() > 0.0f) {
            if (hitEntity.func_70089_S() && hitEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hitEntity;
                if (this.getMimicVanilla()) {
                    target.func_70015_d(2 + (int)((float)(super.func_223314_ad() / 20) + super.getDamage() / 5.0f));
                    target.func_241841_a((ServerWorld)super.func_130014_f_(), this.bolt);
                }
                target.field_70172_ad = 0;
                target.field_70737_aN = 0;
                if (target.func_70097_a(super.getDamageSource(), super.getDamage())) {
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 10, 0, false, false, true));
                }
                this.onFirstImpact(target.func_233580_cy_());
            }
            if (hitEntity instanceof ThrowableEntity) {
                if (hitEntity instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)hitEntity).getDamageSource() != null && ((ModDamageSource)((Object)((AbilityProjectileEntity)hitEntity).getDamageSource())).field_76373_n.equals("lightningBolt")) {
                    return;
                }
                hitEntity.func_70106_y();
            }
        }
    }

    public void onBlockImpact(BlockPos hit) {
        if (this.explosionDestroysBlocks && AbilityHelper.placeBlockIfAllowed(this.getThrower(), hit, Blocks.field_150350_a.func_176223_P(), 3, DefaultProtectionRules.CORE_FOLIAGE_ORE)) {
            super.increaseBlocksAffected((int)this.field_70170_p.func_180495_p(hit).func_185887_b((IBlockReader)this.field_70170_p, hit));
        }
    }

    public void onFirstImpact(BlockPos hit) {
        ProtectedArea area = ProtectedAreasData.get(this.field_70170_p).getProtectedArea(hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p());
        if (area != null && !area.canUseAbility(super.getParent())) {
            return;
        }
        ExplosionAbility explosion = super.createExplosion((Entity)super.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), this.explosionSize);
        explosion.immuneEntities = this.explosionTargets;
        explosion.setExplosionSound(false);
        if (!this.canCauseKnockback) {
            explosion.disableExplosionKnockback();
        }
        explosion.setStaticDamage(super.getDamage() / 2.0f);
        explosion.setDamageSource((DamageSource)super.getDamageSource());
        explosion.setDamageOwner(false);
        explosion.setStaticBlockResistance(this.explosionBlockResistance);
        explosion.setDestroyBlocks(this.explosionDestroysBlocks);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new LightningExplosionParticleEffect(this.explosionSize + 1));
        explosion.setExplosionSound(false);
        explosion.setDamageEntities(true);
        explosion.doExplosion();
        this.explosionTargets.addAll(explosion.damagedEntities);
    }

    @Override
    public void func_70071_h_() {
        if (this.getLightningMovement()) {
            this.seed = this.field_70146_Z.nextLong();
        }
        if (!this.field_70170_p.field_72995_K && super.getBlocksAffected() < super.getBlocksAffectedLimit()) {
            boolean addedTick = false;
            if (this.getLength() != this.travelLength) {
                this.setLength(Math.min(this.getLength() + this.travelSpeed, this.travelLength));
                this.firstTick = true;
                addedTick = true;
            }
            if ((super.getMaxLife() - super.getLife()) % this.targetTimeToReset == 0 && this.hasToCheckForTarget && !addedTick) {
                this.targets.clear();
                this.explosionTargets.clear();
            }
            this.entities.clear();
            this.contactBlocks.clear();
            ProtectedArea area = ProtectedAreasData.get(this.field_70170_p).getProtectedArea((int)super.func_226277_ct_(), (int)super.func_226278_cu_(), (int)super.func_226281_cx_());
            boolean canDestroyBlocks = area == null || area != null && area.canDestroyBlocks();
            boolean canHurtEntities = area == null || area != null && area.canHurtEntities();
            boolean canExplode = this.explosionSize > 0 && canDestroyBlocks && CommonConfig.INSTANCE.isAbilityGriefingEnabled();
            Vector3d lookVec = super.func_70040_Z();
            int i = 0;
            while ((float)i < this.getLength()) {
                double currentX = super.func_226277_ct_() + lookVec.field_72450_a * (double)i;
                double currentY = super.func_226280_cw_() + lookVec.field_72448_b * (double)i;
                double currentZ = super.func_226281_cx_() + lookVec.field_72449_c * (double)i;
                double boxSize = 0.2 + (double)this.getSize() / this.boxSizeDivision;
                AxisAlignedBB alignedBB = new AxisAlignedBB(currentX - boxSize, currentY - boxSize, currentZ - boxSize, currentX + boxSize, currentY + boxSize, currentZ + boxSize);
                this.field_70170_p.func_72839_b((Entity)super.getThrower(), alignedBB).stream().filter(e -> !this.entities.contains(e)).forEach(this.entities::add);
                if (canExplode || !this.getMimicVanilla()) {
                    BlockPos currentBlockPos = new BlockPos(currentX, currentY, currentZ);
                    BlockState blockState = this.field_70170_p.func_180495_p(currentBlockPos);
                    if (blockState.func_177230_c() == Blocks.field_180401_cv || blockState.func_177230_c() == ModBlocks.BARRIER.get() || blockState.func_177230_c().func_199767_j().func_206844_a(ModTags.Items.KAIROSEKI)) {
                        super.func_70106_y();
                        return;
                    }
                    int minX = (int)Math.floor(alignedBB.field_72340_a);
                    int minY = (int)Math.floor(alignedBB.field_72338_b);
                    int minZ = (int)Math.floor(alignedBB.field_72339_c);
                    int maxX = (int)Math.floor(alignedBB.field_72336_d);
                    int maxY = (int)Math.floor(alignedBB.field_72337_e);
                    int maxZ = (int)Math.floor(alignedBB.field_72334_f);
                    BlockPos.Mutable checkedPos = new BlockPos.Mutable(0, 0, 0);
                    for (int x = minX; x < maxX; ++x) {
                        for (int y = minY; y < maxY; ++y) {
                            for (int z = minZ; z < maxZ; ++z) {
                                checkedPos.func_181079_c(x, y, z);
                                long packedPos = checkedPos.func_218275_a();
                                if (this.field_70170_p.func_180495_p((BlockPos)checkedPos).func_185904_a() == Material.field_151579_a || this.contactBlocks.contains(packedPos) || checkedPos.equals((Object)currentBlockPos)) continue;
                                this.contactBlocks.add(packedPos);
                            }
                        }
                    }
                    if (this.firstTick && blockState.func_185904_a() != Material.field_151579_a && !this.firstContactBlocks.contains(currentBlockPos)) {
                        this.firstContactBlocks.add(currentBlockPos);
                    }
                    if ((float)i == this.getLength()) {
                        this.finalPos = currentBlockPos;
                    }
                }
                ++i;
            }
            if (canHurtEntities) {
                this.entities.forEach(this::onEntityImpactEvent);
            }
            if ((this.field_70173_aa % 5 == 0 || this.firstTick) && canExplode) {
                if (this.firstTick) {
                    for (BlockPos hit : this.firstContactBlocks) {
                        if (super.getBlocksAffected() < super.getBlocksAffectedLimit()) {
                            this.onFirstImpact(hit);
                            continue;
                        }
                        break;
                    }
                } else {
                    for (Long packedPos : this.contactBlocks) {
                        if (super.getBlocksAffected() < super.getBlocksAffectedLimit()) {
                            BlockPos hit = BlockPos.func_218283_e((long)packedPos);
                            this.onBlockImpact(hit);
                            continue;
                        }
                        break;
                    }
                }
                if (super.getDamage() > 12.0f && this.finalPos != null && this.finalPos.func_177956_o() > 128) {
                    ((ServerWorld)this.field_70170_p).func_241113_a_(0, 0, true, true);
                }
            }
        }
        if (this.firstTick && this.getLength() == this.travelLength) {
            this.firstTick = false;
        } else if (this.getMimicVanilla()) {
            this.field_70170_p.func_225605_c_(4);
        }
        super.func_70071_h_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * Entity.func_184183_bd();
        return distance < d0 * d0;
    }

    public void setExplosion(int range) {
        this.explosionSize = range;
    }

    public void setExplosion(int range, boolean destroysBlocks) {
        this.explosionSize = range;
        this.explosionDestroysBlocks = destroysBlocks;
    }

    public void setExplosion(int range, boolean destroysBlocks, float explosionBlockResistance) {
        this.explosionSize = range;
        this.explosionDestroysBlocks = destroysBlocks;
        this.explosionBlockResistance = explosionBlockResistance;
    }

    public void setTargetTimeToReset(int value) {
        this.targetTimeToReset = value;
    }

    public void disableExplosionKnockback() {
        this.canCauseKnockback = false;
    }

    public double getBoxSizeDivision() {
        return this.boxSizeDivision;
    }

    public void setBoxSizeDivision(double value) {
        this.boxSizeDivision = value;
    }

    public void setLength(float length) {
        this.length = length;
        this.updateClient();
    }

    public float getLength() {
        return this.length;
    }

    public void setSize(float size) {
        this.size = size;
        this.updateClient();
    }

    public float getSize() {
        return this.size;
    }

    public void setBranches(int branches) {
        this.branches = branches;
        this.updateClient();
    }

    public int getBranches() {
        return this.branches;
    }

    public void setSegments(int segments) {
        this.segments = segments;
        this.updateClient();
    }

    public int getSegments() {
        return this.segments;
    }

    public void setColor(Color color) {
        this.color = color.getRGB();
        this.alpha = color.getAlpha();
        this.updateClient();
    }

    public int getColor() {
        return this.color;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAngle(int angle) {
        this.angle = Math.round(WyHelper.clamp(angle, 0L, 180L));
        this.updateClient();
    }

    public int getAngle() {
        return this.angle;
    }

    public void setLightningMimic(boolean hasLightningMimic) {
        this.mimicVanilla = hasLightningMimic;
        this.updateClient();
    }

    public boolean getMimicVanilla() {
        return this.mimicVanilla;
    }

    public void setLightningMovement(boolean hasLightningMovement) {
        this.lightningMovement = hasLightningMovement;
        this.updateClient();
    }

    public boolean getLightningMovement() {
        return this.lightningMovement;
    }

    public void setEnergyEffect(boolean hasEnergyEffect) {
        this.energyEffect = hasEnergyEffect;
        this.updateClient();
    }

    public boolean getEnergyEffect() {
        return this.energyEffect;
    }

    public void setLightningProperties(float length, float size, int branches, int segments, int color, int alpha, int angle, boolean mimicVanilla, boolean lightningMovement, boolean energyEffect) {
        this.length = length;
        this.size = size;
        this.branches = branches;
        this.segments = segments;
        this.color = color;
        this.alpha = alpha;
        this.angle = angle;
        this.mimicVanilla = mimicVanilla;
        this.lightningMovement = lightningMovement;
        this.energyEffect = energyEffect;
        this.updateClient();
    }

    private void updateClient() {
        if (!this.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateLightningEntity(this), super.getThrower());
        }
    }
}

