/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.goro;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.GoroProjectiles;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RaigoProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private boolean dealtAOE = false;
    private boolean closeToFloor = false;
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE, CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE).build();
    private float EXPLOSION_RADIUS = 0.7f;
    private float SHOCKWAVE_RADIUS = 0.85f;

    public RaigoProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public RaigoProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)GoroProjectiles.RAIGO.get(), world, player, ability.getCore());
        super.setDamage(100.0f);
        super.setMaxLife(256);
        super.setEntityCollisionSize(4.0);
        super.setPassThroughEntities();
        super.setCanGetStuckInGround();
        super.setTargetResetTime(120);
        super.setArmorPiercing(0.75f);
        super.setUnavoidable();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    public void onBlockImpactEvent(BlockPos hit) {
        int explosionRadius = (int)(this.EXPLOSION_RADIUS * this.getSize());
        int shockwaveRadius = (int)(this.SHOCKWAVE_RADIUS * this.getSize());
        AbilityHelper.createSphere(this.field_70170_p, this.func_233580_cy_().func_177979_c(explosionRadius / 8), explosionRadius, explosionRadius, false, Blocks.field_150350_a, 3, GRIEF_RULE);
        if (!this.dealtAOE) {
            List<Entity> list = WyHelper.getNearbyEntities(this.func_213303_ch(), (IWorld)this.field_70170_p, (double)shockwaveRadius, null, Entity.class);
            list.remove(this.getThrower());
            for (Entity target : list) {
                if (target instanceof ThrowableEntity || target instanceof AbstractArrowEntity) {
                    target.func_70106_y();
                }
                if (!(target instanceof LivingEntity)) continue;
                target.func_70097_a((DamageSource)AbilityDamageSource.causeAbilityDamage(this.getThrower(), super.getParent()), super.getDamage());
                Vector3d speed = target.func_70040_Z().func_186678_a(-1.0).func_216372_d(5.0, 0.0, 5.0);
                target.func_213293_j(speed.field_72450_a, 1.0, speed.field_72449_c);
                target.field_70133_I = true;
            }
            this.dealtAOE = true;
        }
    }

    private void onTickEvent() {
        super.setDamage(2.0f * this.getSize());
        if (!this.field_70170_p.field_72995_K) {
            BlockRayTraceResult mop;
            for (int i = 0; i < 25; ++i) {
                ParticleType goro_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO.get() : (ParticleType)ModParticleTypes.GORO_YELLOW.get();
                ParticleType goro2_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO2.get() : (ParticleType)ModParticleTypes.GORO2_YELLOW.get();
                ParticleType particleToUse = this.field_70173_aa % 2 == 0 ? goro2_particle : goro_particle;
                double offsetX = WyHelper.randomDouble() * 5.0;
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble() * 5.0;
                SimpleParticleData data = new SimpleParticleData(particleToUse);
                data.setLife(20);
                data.setSize(7.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            this.func_70101_b(0.0f, 90.0f);
            if (!this.closeToFloor && (mop = WyHelper.rayTraceBlocks((Entity)this, 30.0)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)) {
                this.setMaxLife(16);
                this.closeToFloor = true;
            }
            if (this.field_70173_aa % 5 == 0) {
                for (int j = 0; j < 10; ++j) {
                    float boltLength = (float)WyHelper.randomWithRange(36, 50);
                    LightningEntity bolt = new LightningEntity((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)WyHelper.randomWithRange(0, 360), (float)WyHelper.randomWithRange(-90, 90), boltLength, boltLength, super.getParent());
                    bolt.setAngle(20);
                    bolt.setMaxLife(20);
                    bolt.setDamage(0.0f);
                    bolt.setExplosion(0, false);
                    bolt.setSize(boltLength / 800.0f);
                    bolt.setColor(ClientConfig.INSTANCE.isGoroBlue() ? ElThorAbility.BLUE_THUNDER : ElThorAbility.YELLOW_THUNDER);
                    bolt.setBranches(3);
                    bolt.setSegments(10);
                    this.field_70170_p.func_217376_c((Entity)bolt);
                }
            }
        }
    }

    @Override
    public float getSize() {
        return (float)super.func_174813_aQ().func_72320_b() * 4.0f;
    }

    public void increaseSize(float increaseAmount) {
        float size = (float)super.func_174813_aQ().func_72320_b() + increaseAmount;
        super.setEntityCollisionSize(size);
        super.setBlockCollisionSize(size);
    }
}

