/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.gura;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gura.GuraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GekishinProjectile
extends AbilityProjectileEntity {
    private Interval explosionInterval = new Interval(2);

    public GekishinProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public GekishinProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)GuraProjectiles.GEKISHIN.get(), world, player, ability.getCore());
        super.setDamage(70.0f);
        super.setMaxLife(50);
        super.setEntityCollisionSize(5.0);
        super.setPassThroughEntities();
        super.setPassThroughBlocks();
        super.setEntityCollisionSize(3.0);
        super.setArmorPiercing(0.75f);
        super.setBlocksAffectedLimit(12000);
        super.setUnavoidable();
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        for (int i = 0; i < 3; ++i) {
            if (this.explosionInterval.canTick()) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, super.func_226277_ct_() + WyHelper.randomDouble() * 1.5, super.func_226278_cu_() + WyHelper.randomDouble() * 1.5, super.func_226281_cx_() + WyHelper.randomDouble() * 1.5, 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            double offsetX = WyHelper.randomDouble() * 5.0;
            double offsetY = WyHelper.randomDouble() * 5.0;
            double offsetZ = WyHelper.randomDouble() * 5.0;
            SimpleParticleData data = new SimpleParticleData(this.field_70146_Z.nextDouble() > 0.5 ? (ParticleType)ModParticleTypes.MOKU.get() : (ParticleType)ModParticleTypes.MOKU2.get());
            data.setLife(3);
            data.setSize(10.0f);
            WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + offsetY, super.func_226281_cx_() + offsetZ);
        }
        int size = 0;
        ExplosionAbility explosion = super.createExplosion((Entity)super.getThrower(), this.field_70170_p, super.func_226277_ct_(), super.func_226278_cu_(), super.func_226281_cx_(), 8.0f);
        explosion.setHeightDifference(45);
        explosion.setStaticBlockResistance(1.35f);
        explosion.setProtectOwnerFromFalling(true);
        explosion.setExplosionSound(false);
        explosion.setSmokeParticles(null);
        explosion.setDamageSource(this.bypassingSource);
        explosion.setStaticDamage(15.0f);
        explosion.addRemovedBlocksToList();
        explosion.doExplosion();
        for (FallingBlockEntity entity : explosion.removedBlocks) {
            entity.func_213293_j(WyHelper.randomWithRange(-1, 1) / 2.0, 0.5 + WyHelper.randomDouble(), WyHelper.randomWithRange(-1, 1) / 2.0);
            entity.field_70133_I = true;
            entity.field_145813_c = false;
            entity.field_145812_b = 1;
            this.field_70170_p.func_217376_c((Entity)entity);
            if (++size <= 50) continue;
            break;
        }
    }
}

