/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hana;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.abilities.hana.CampoDeFloresAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class CampoDeFloresEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private LivingEntity owner;
    private CampoDeFloresAbility ability;
    private static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().testEnemyFaction().selector(entity -> DevilFruitHelper.getDifferenceToFloor((Entity)entity) < 3.0);

    public CampoDeFloresEntity(EntityType type, World pLevel) {
        super(type, pLevel);
    }

    public CampoDeFloresEntity(World level, CampoDeFloresAbility ability) {
        super((EntityType)HanaProjectiles.CAMPO_DE_FLORES.get(), level);
        this.ability = ability;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > 100) {
                this.func_70106_y();
                return;
            }
            if (this.owner == null || !this.owner.func_70089_S()) {
                this.func_70106_y();
                return;
            }
            List targets = this.ability.getComponent(ModAbilityKeys.RANGE).map(comp -> comp.getTargetsInArea(this.owner, this.func_233580_cy_(), 10.0f, TARGETS_PREDICATE)).orElse(new ArrayList());
            for (LivingEntity target : targets) {
                boolean flag = this.ability.getComponent(ModAbilityKeys.DAMAGE).map(comp -> comp.hurtTarget(this.owner, target, 10.0f)).orElse(false);
                if (!flag) continue;
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0));
                target.func_213293_j(0.0, 1.75, 0.0);
                target.field_70133_I = true;
            }
        }
    }

    public EntitySize func_213305_a(Pose pose) {
        EntitySize newSize = this.func_200600_R().func_220334_j().func_220312_a(20.0f, 1.0f);
        return newSize;
    }

    protected void func_70037_a(CompoundNBT pCompound) {
    }

    protected void func_213281_b(CompoundNBT pCompound) {
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_179252_a(this.owner != null ? this.owner.func_110124_au() : Util.field_240973_b_);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.owner = this.field_70170_p.func_217371_b(buffer.func_179253_g());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

