/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hana;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.hana.CienFleurStompAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hana.HanaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HanaFeetEntity
extends AbilityProjectileEntity {
    public HanaFeetEntity(EntityType type, World world) {
        super(type, world);
    }

    public HanaFeetEntity(World world, LivingEntity player, Ability ability) {
        super((EntityType)HanaProjectiles.FEET.get(), world, player, ability);
        this.setMaxLife(35);
        this.setDamage(10.0f);
        this.setPassThroughEntities();
        super.setFist();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    public void onBlockImpactEvent(BlockPos pos) {
        if (this.getThrower() == null) {
            return;
        }
        List<LivingEntity> list = WyHelper.getNearbyLiving(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), (IWorld)this.field_70170_p, 5.0, ModEntityPredicates.getEnemyFactions(this.getThrower()));
        list.remove(this.getThrower());
        for (LivingEntity target : list) {
            if (!target.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(this.getThrower(), CienFleurStompAbility.INSTANCE), this.getDamage())) continue;
            target.func_213317_d(target.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
            target.field_70133_I = true;
        }
        List<BlockPos> blocks = WyHelper.getNearbyBlocks(this.func_233580_cy_(), (IWorld)this.field_70170_p, 5, p -> FoliageBlockProtectionRule.INSTANCE.isApproved(this.field_70170_p.func_180495_p(p)), (List<Block>)ImmutableList.of((Object)Blocks.field_150350_a));
        for (BlockPos p2 : blocks) {
            BlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(p2.func_177958_n(), p2.func_177956_o(), p2.func_177952_p()));
            for (int i = 0; i < 150; ++i) {
                double offsetX = WyHelper.randomDouble();
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble();
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), (double)p2.func_177958_n() + offsetX, (double)p2.func_177956_o() + offsetY, (double)p2.func_177952_p() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            AbilityHelper.placeBlockIfAllowed(this.getThrower(), p2, Blocks.field_150350_a.func_176223_P(), FoliageBlockProtectionRule.INSTANCE);
        }
        BlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        if (blockState.func_185904_a().func_76220_a()) {
            for (int i = 0; i < 150; ++i) {
                double x = WyHelper.randomDouble();
                double z = WyHelper.randomDouble();
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), (double)pos.func_177958_n() + WyHelper.randomWithRange(-3, 3) + x, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + WyHelper.randomWithRange(-3, 3) + z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onProjectileCollision(AbilityProjectileEntity owner, AbilityProjectileEntity target) {
    }
}

