/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.magu;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.api.protection.block.LavaImmuneProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.magu.MaguProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DaiFunkaProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(DefaultProtectionRules.CORE_FOLIAGE_ORE, LavaImmuneProtectionRule.INSTANCE).build();
    private boolean changeLifeTime = true;

    public DaiFunkaProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public DaiFunkaProjectile(World world, LivingEntity player, IAbility ability) {
        super((EntityType)MaguProjectiles.DAI_FUNKA.get(), world, player, ability.getCore());
        super.setDamage(80.0f);
        super.setMaxLife(35);
        super.setPassThroughEntities();
        super.setCanGetStuckInGround();
        super.setArmorPiercing(1.0f);
        super.addBlockToIgnore(Blocks.field_150353_l);
        this.setEntityCollisionSize(7.0, 7.0, 7.0);
        this.setBlockCollisionSize(6.0, 2.0, 6.0);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        AbilityHelper.setSecondsOnFireBy((Entity)hitEntity, 15, this.getThrower());
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.createFilledSphere(this.field_70170_p, (int)super.func_226277_ct_(), (int)super.func_226278_cu_(), (int)super.func_226281_cx_(), 3, Blocks.field_150353_l, GRIEF_RULE);
        if (this.changeLifeTime) {
            super.setLife(3);
            this.changeLifeTime = false;
        }
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            SimpleParticleData data;
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 2; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                data = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                data.setLife(3);
                data.setSize(2.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + offsetY, super.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 2; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                data = new SimpleParticleData((ParticleType)ModParticleTypes.MAGU.get());
                data.setLife(3);
                data.setSize(2.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + offsetY, super.func_226281_cx_() + offsetZ);
            }
        }
    }
}

