/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.mera;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HidarumaProjectile
extends AbilityProjectileEntity {
    private Optional<LivingEntity> target;

    public HidarumaProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public HidarumaProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)MeraProjectiles.HIDARUMA.get(), world, player, ability.getCore());
        super.setDamage(3.5f);
        super.setArmorPiercing(0.75f);
        super.setGravity(0.0f);
        super.setMaxLife(120);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        AbilityHelper.setSecondsOnFireBy((Entity)hitEntity, 3, this.getThrower());
        super.func_70106_y();
    }

    public void setTarget(Optional<LivingEntity> target) {
        this.target = target;
    }

    private void onTickEvent() {
        if (this.target == null || !this.target.isPresent() || !this.target.get().func_70089_S()) {
            List list = WyHelper.getNearbyLiving(super.func_213303_ch(), (IWorld)this.field_70170_p, 16.0, ModEntityPredicates.getEnemyFactions(super.getThrower()));
            list.remove(super.getThrower());
            list.sort(MobsHelper.ENTITY_THREAT);
            if (list.size() > 0) {
                this.target = list.stream().findAny();
            }
        } else {
            Vector3d dist = super.func_213303_ch().func_178788_d(this.target.get().func_213303_ch()).func_72441_c(0.0, -1.0, 0.0);
            double speedReduction = 12.0;
            double speed = 0.5;
            double xSpeed = Math.min(speed, -dist.field_72450_a / speedReduction);
            double ySpeed = Math.min(speed, -dist.field_72448_b / speedReduction);
            double zSpeed = Math.min(speed, -dist.field_72449_c / speedReduction);
            super.func_213293_j(xSpeed, ySpeed, zSpeed);
            this.field_70133_I = true;
        }
        if (super.func_208600_a((ITag)FluidTags.field_206959_a)) {
            super.func_70106_y();
            super.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, super.func_226277_ct_(), super.func_226278_cu_() + 1.1, super.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197632_y, (ServerWorld)this.field_70170_p, super.func_226277_ct_() + offsetX, super.func_226278_cu_() + offsetY, super.func_226281_cx_() + offsetZ);
            }
        }
    }
}

