/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.moku;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.MokuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WhiteSnakeProjectile
extends AbilityProjectileEntity {
    private Optional<LivingEntity> target;

    public WhiteSnakeProjectile(EntityType type, World world) {
        super(type, world);
    }

    public WhiteSnakeProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)MokuProjectiles.WHITE_SNAKE.get(), world, player, ability);
        this.setDamage(25.0f);
        this.setMaxLife(40);
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_76436_u, 300, 0)};
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (this.target == null || !this.target.isPresent() || !this.target.get().func_70089_S() || this.target.get().func_213303_ch().func_72436_e(this.func_213303_ch()) > 15.0) {
            List list = WyHelper.getNearbyLiving(this.func_213303_ch(), (IWorld)this.field_70170_p, 5.0, ModEntityPredicates.getEnemyFactions(this.getThrower()));
            list.remove(this.getThrower());
            list.sort(MobsHelper.ENTITY_THREAT);
            if (list.size() > 0) {
                this.target = list.stream().findAny();
            }
        } else {
            Vector3d dist = this.func_213303_ch().func_178788_d(this.target.get().func_213303_ch()).func_72441_c(0.0, -1.0, 0.0);
            double speedReduction = 12.0;
            double speed = 0.6;
            double xSpeed = Math.min(speed, -dist.field_72450_a / speedReduction);
            double ySpeed = Math.min(speed, -dist.field_72448_b / speedReduction);
            double zSpeed = Math.min(speed, -dist.field_72449_c / speedReduction);
            this.func_213293_j(xSpeed, ySpeed, zSpeed);
            this.field_70133_I = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 40; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.MOKU2.get());
                data.setLife(10);
                data.setSize((float)(WyHelper.randomDouble() * 4.0));
                data.setColor(0.8f, 0.8f, 0.8f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

