/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.sniper;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.sniper.HiNoToriBoshiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.sniper.SniperProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HiNoToriBoshiProjectile
extends AbilityProjectileEntity {
    public HiNoToriBoshiProjectile(EntityType type, World world) {
        super(type, world);
        this.setDamage(25.0f);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    public HiNoToriBoshiProjectile(World world, LivingEntity player) {
        this((EntityType)SniperProjectiles.HI_NO_TORI_BOSHI.get(), world, player, HiNoToriBoshiAbility.INSTANCE);
    }

    public HiNoToriBoshiProjectile(EntityType type, World world, LivingEntity player, AbilityCore<?> parent) {
        super(type, world, player, parent);
        this.setDamage(25.0f);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        if (hitEntity instanceof CreeperEntity) {
            ((CreeperEntity)hitEntity).func_146079_cb();
            return;
        }
        AbilityHelper.setSecondsOnFireBy((Entity)hitEntity, 5, this.getThrower());
    }

    private void onBlockImpactEvent(BlockPos hit) {
        if (this.field_70170_p.func_180495_p(hit).func_177230_c() == ModBlocks.OIL_SPILL.get()) {
            ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 4.0f);
            explosion.setStaticDamage(10.0f);
            explosion.setFireAfterExplosion(true);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(4));
            explosion.doExplosion();
            return;
        }
        AbilityHelper.placeBlockIfAllowed(this.getThrower(), hit.func_177982_a(0, 1, 0), Blocks.field_150480_ab.func_176223_P(), AirBlockProtectionRule.INSTANCE);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                data.setLife(10);
                data.setSize(1.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.2 + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

