/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.zushi;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.zushi.ZushiProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MokoProjectile
extends AbilityProjectileEntity {
    public MokoProjectile(EntityType<Entity> type, World world) {
        super(type, world);
    }

    public MokoProjectile(World world, LivingEntity player, Ability ability) {
        super((EntityType)ZushiProjectiles.MOKO.get(), world, player, ability.getCore());
        super.setDamage(10.0f);
        super.setPassThroughEntities();
        super.setArmorPiercing(1.0f);
        super.setUnavoidable();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpact;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpact(BlockPos hit) {
        ExplosionAbility explosion = super.createExplosion((Entity)this.getThrower(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 3.0f);
        explosion.setStaticDamage(15.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setExplosionSound(false);
        explosion.setSmokeParticles(null);
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }

    private void onEntityImpactEvent(LivingEntity target) {
        for (int x = -1; x < 1; ++x) {
            for (int z = -1; z < 1; ++z) {
                if (!AbilityHelper.placeBlockIfAllowed(this.getThrower(), this.func_233580_cy_(), Blocks.field_150350_a.func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                target.func_213293_j(0.0, -5.0, 0.0);
                target.field_70133_I = true;
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 10));
            }
        }
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 25; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.GASU.get());
                data.setLife(10);
                data.setSize(1.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

