/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.zoan;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.abilities.ryuallosaurus.AllosaurusHeavyPointAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.models.morphs.AllosaurusHeavyPartialModel;
import xyz.pixelatedw.mineminenomi.renderers.morphs.AllosaurusHeavyPartialMorphRenderer;

public class AllosaurusHeavyMorphInfo
extends MorphInfo {
    private static final EntitySize STANDING_SIZE = EntitySize.func_220314_b((float)0.9f, (float)2.8f);
    private static final EntitySize CROUCHING_SIZE = EntitySize.func_220314_b((float)0.9f, (float)2.6f);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory(LivingEntity entity) {
        boolean isSlim = false;
        if (entity instanceof AbstractClientPlayerEntity) {
            isSlim = ((AbstractClientPlayerEntity)entity).func_175154_l().equals("slim");
        }
        return new AllosaurusHeavyPartialMorphRenderer.Factory(this, isSlim);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MorphModel getModel() {
        return new AllosaurusHeavyPartialModel();
    }

    @Override
    @Nullable
    public AkumaNoMiItem getDevilFruit() {
        return ModAbilities.RYU_RYU_NO_MI_ALLOSAURUS;
    }

    @Override
    public boolean isPartial() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFirstPersonHand() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFirstPersonLeg() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
        float scale = 1.4f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    @Override
    public String getForm() {
        return "allosaurus_heavy";
    }

    @Override
    public String getDisplayName() {
        return AllosaurusHeavyPointAbility.INSTANCE.getUnlocalizedName();
    }

    @Override
    public double getEyeHeight() {
        return 2.5;
    }

    @Override
    public float getShadowSize() {
        return 0.8f;
    }

    @Override
    public Map<Pose, EntitySize> getSizes() {
        return ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_SIZE).put((Object)Pose.CROUCHING, (Object)CROUCHING_SIZE).build();
    }
}

