/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCache;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingDamageEvent;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class ChallengesEvents {
    @SubscribeEvent
    public static void onEntityJoinsWorld(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K && WyHelper.isInChallengeDimension(player.field_70170_p)) {
            ServerWorld overworld = player.func_184102_h().func_71218_a(World.field_234918_g_);
            ChallengesWorldData worldData = ChallengesWorldData.get();
            InProgressChallenge challenge = worldData.getInProgressChallengeFor((LivingEntity)player);
            if (challenge != null) {
                challenge.despawnChallenger((LivingEntity)player);
            } else {
                Optional<ChallengeCache> cache = worldData.getChallengerCache(player.func_110124_au());
                if (cache.isPresent()) {
                    cache.get().restore((LivingEntity)player);
                    worldData.removeChallengerCache(player.func_110124_au());
                }
                ((ServerPlayerEntity)player).func_200619_a(overworld, (double)overworld.func_241135_u_().func_177958_n(), (double)overworld.func_241135_u_().func_177956_o(), (double)overworld.func_241135_u_().func_177952_p(), 270.0f, 0.0f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityDies(LivingDeathEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living instanceof PlayerEntity && WyHelper.isInChallengeDimension(living.field_70170_p)) {
            living.func_195064_c(new EffectInstance((Effect)ModEffects.CHALLENGE_FAILED.get(), 40, 0, false, false));
            living.func_70606_j(1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDamage(WyLivingDamageEvent event) {
        OPBossEntity entity;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof OPBossEntity && (entity = (OPBossEntity)event.getEntityLiving()).getDamageCeiling() > 0.0f && event.getAmount() > entity.getDamageCeiling()) {
            float diff = event.getAmount() - entity.getDamageCeiling();
            float extra = diff / 3.0f;
            float finalAmount = event.getAmount() - diff + extra;
            event.setAmount(finalAmount);
        }
    }
}

