/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.FlyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.config.GeneralConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityValidationEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class ConfigEvents {
    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            boolean hasUnlockedFlying;
            if (WyHelper.isInChallengeDimension(event.getOriginal().field_70170_p)) {
                ServerPlayerEntity oldPlayer = (ServerPlayerEntity)event.getOriginal();
                ServerPlayerEntity newPlayer = (ServerPlayerEntity)event.getPlayer();
                newPlayer.field_71071_by.func_70455_b(oldPlayer.field_71071_by);
                newPlayer.func_70606_j(oldPlayer.func_110143_aJ());
                newPlayer.field_71068_ca = oldPlayer.field_71068_ca;
                newPlayer.field_71067_cb = oldPlayer.field_71067_cb;
                newPlayer.field_71106_cc = oldPlayer.field_71106_cc;
                newPlayer.func_85040_s(oldPlayer.func_71037_bA());
                ConfigEvents.restoreFullData((PlayerEntity)oldPlayer, (PlayerEntity)newPlayer);
                return;
            }
            IDevilFruit oldDevilFruitProps = DevilFruitCapability.get((LivingEntity)event.getOriginal());
            IDevilFruit newDevilFruitProps = DevilFruitCapability.get((LivingEntity)event.getPlayer());
            IAbilityData newAbilityData = AbilityDataCapability.get((LivingEntity)event.getPlayer());
            if (oldDevilFruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) && !((MorphInfo)ModMorphs.YOMI_SKELETON.get()).isActive((LivingEntity)event.getOriginal())) {
                ConfigEvents.restoreFullData(event.getOriginal(), event.getPlayer());
                DevilFruitCapability.get((LivingEntity)event.getPlayer()).setDevilFruit(ModAbilities.YOMI_YOMI_NO_MI);
                DevilFruitCapability.get((LivingEntity)event.getPlayer()).setZoanPoint(((MorphInfo)ModMorphs.YOMI_SKELETON.get()).getForm());
                return;
            }
            IEntityStats oldEntityStats = EntityStatsCapability.get((LivingEntity)event.getOriginal());
            INBT oldEntityStatsNBT = EntityStatsCapability.INSTANCE.writeNBT((Object)oldEntityStats, null);
            IEntityStats newEntityStats = EntityStatsCapability.get((LivingEntity)event.getPlayer());
            EntityStatsCapability.INSTANCE.readNBT((Object)newEntityStats, null, oldEntityStatsNBT);
            if (((Boolean)GeneralConfig.RACE_KEEP.get()).booleanValue()) {
                newEntityStats.setRace(oldEntityStats.getRace());
                newEntityStats.setSubRace(oldEntityStats.getSubRace());
            }
            if (((Boolean)GeneralConfig.FACTION_KEEP.get()).booleanValue()) {
                newEntityStats.setFaction(oldEntityStats.getFaction());
            }
            if (((Boolean)GeneralConfig.FIGHTING_STYLE_KEEP.get()).booleanValue()) {
                newEntityStats.setFightingStyle(oldEntityStats.getFightingStyle());
            }
            if (((Boolean)GeneralConfig.DEVIL_FRUIT_KEEP.get()).booleanValue()) {
                INBT oldFruitNBT = DevilFruitCapability.INSTANCE.writeNBT((Object)oldDevilFruitProps, null);
                DevilFruitCapability.INSTANCE.readNBT((Object)newDevilFruitProps, null, oldFruitNBT);
            }
            double dorikiLeft = WyHelper.percentage(CommonConfig.INSTANCE.getDorikiKeepPercentage(), oldEntityStats.getDoriki());
            newEntityStats.alterDoriki(dorikiLeft - oldEntityStats.getDoriki(), StatChangeSource.DEATH);
            long bountyLeft = (long)WyHelper.percentage(CommonConfig.INSTANCE.getBountyKeepPercentage(), oldEntityStats.getBounty());
            newEntityStats.alterBounty(bountyLeft - oldEntityStats.getBounty(), StatChangeSource.DEATH);
            long bellyLeft = (long)WyHelper.percentage(CommonConfig.INSTANCE.getBellyKeepPercentage(), oldEntityStats.getBelly());
            newEntityStats.alterBelly(bellyLeft - oldEntityStats.getBelly(), StatChangeSource.DEATH);
            long extolLeft = (long)WyHelper.percentage(CommonConfig.INSTANCE.getBellyKeepPercentage(), oldEntityStats.getExtol());
            newEntityStats.alterExtol(extolLeft - oldEntityStats.getExtol(), StatChangeSource.DEATH);
            IHakiData oldHakiProps = HakiDataCapability.get((LivingEntity)event.getOriginal());
            INBT oldHakiPropsNBT = HakiDataCapability.INSTANCE.writeNBT((Object)oldHakiProps, null);
            IHakiData newHakiProps = HakiDataCapability.get((LivingEntity)event.getPlayer());
            HakiDataCapability.INSTANCE.readNBT((Object)newHakiProps, null, oldHakiPropsNBT);
            float hardeningBusoExpLeft = (float)WyHelper.percentage(CommonConfig.INSTANCE.getHakiExpKeepPercentage(), oldHakiProps.getBusoshokuHakiExp());
            newHakiProps.alterBusoshokuHakiExp(hardeningBusoExpLeft - oldHakiProps.getBusoshokuHakiExp(), StatChangeSource.DEATH);
            float observationExpLeft = (float)WyHelper.percentage(CommonConfig.INSTANCE.getHakiExpKeepPercentage(), oldHakiProps.getKenbunshokuHakiExp());
            newHakiProps.alterKenbunshokuHakiExp(observationExpLeft - oldHakiProps.getKenbunshokuHakiExp(), StatChangeSource.DEATH);
            int loyaltyLeft = (int)WyHelper.percentage(((Integer)GeneralConfig.LOYALTY_KEEP_PERCENTAGE.get()).intValue(), oldEntityStats.getLoyalty());
            newEntityStats.alterLoyalty((double)loyaltyLeft - oldEntityStats.getLoyalty(), StatChangeSource.DEATH);
            ConfigEvents.restorePermaData(event.getOriginal(), event.getPlayer());
            AbilityHelper.enableAbilities((LivingEntity)event.getPlayer(), (Predicate<IAbility>)Predicates.alwaysTrue());
            AbilityValidationEvents.validateUnlockedAbilities((LivingEntity)event.getPlayer());
            WyNetwork.sendTo(new SSyncDevilFruitPacket(event.getPlayer().func_145782_y(), newDevilFruitProps), event.getPlayer());
            WyNetwork.sendTo(new SSyncAbilityDataPacket(event.getPlayer().func_145782_y(), newAbilityData), event.getPlayer());
            boolean bl = hasUnlockedFlying = AbilityDataCapability.get((LivingEntity)event.getPlayer()).getPassiveAbilities(abl -> abl instanceof FlyAbility && !((FlyAbility)abl).isPaused()).size() > 0;
            if (hasUnlockedFlying && !event.getPlayer().func_184812_l_() && !event.getPlayer().func_175149_v()) {
                event.getPlayer().field_71075_bZ.field_75101_c = false;
                event.getPlayer().field_71075_bZ.field_75100_b = false;
                ((ServerPlayerEntity)event.getPlayer()).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(event.getPlayer().field_71075_bZ));
            }
        } else {
            ConfigEvents.restoreFullData(event.getOriginal(), event.getPlayer());
        }
    }

    private static void restoreFullData(PlayerEntity original, PlayerEntity player) {
        IDevilFruit oldDevilFruitProps = DevilFruitCapability.get((LivingEntity)original);
        IDevilFruit newDevilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData newAbilityData = AbilityDataCapability.get((LivingEntity)player);
        CompoundNBT nbt = new CompoundNBT();
        IEntityStats oldEntityStats = EntityStatsCapability.get((LivingEntity)original);
        nbt = EntityStatsCapability.INSTANCE.writeNBT((Object)oldEntityStats, null);
        IEntityStats newEntityStats = EntityStatsCapability.get((LivingEntity)player);
        EntityStatsCapability.INSTANCE.readNBT((Object)newEntityStats, null, (INBT)nbt);
        newEntityStats.setCola(Math.max(Math.min(oldEntityStats.getCola(), newEntityStats.getMaxCola()), 0));
        nbt = DevilFruitCapability.INSTANCE.writeNBT((Object)oldDevilFruitProps, null);
        DevilFruitCapability.INSTANCE.readNBT((Object)newDevilFruitProps, null, (INBT)nbt);
        newDevilFruitProps.setZoanPoint("");
        IAbilityData oldAbilityData = AbilityDataCapability.get((LivingEntity)original);
        nbt = AbilityDataCapability.INSTANCE.writeNBT((Object)oldAbilityData, null);
        AbilityDataCapability.INSTANCE.readNBT((Object)newAbilityData, null, (INBT)nbt);
        IHakiData oldHakiData = HakiDataCapability.get((LivingEntity)original);
        nbt = HakiDataCapability.INSTANCE.writeNBT((Object)oldHakiData, null);
        IHakiData newHakiData = HakiDataCapability.get((LivingEntity)player);
        HakiDataCapability.INSTANCE.readNBT((Object)newHakiData, null, (INBT)nbt);
        ConfigEvents.restorePermaData(original, player);
    }

    private static void restorePermaData(PlayerEntity original, PlayerEntity player) {
        CompoundNBT nbt = new CompoundNBT();
        IQuestData oldQuestData = QuestDataCapability.get(original);
        nbt = QuestDataCapability.INSTANCE.writeNBT((Object)oldQuestData, null);
        IQuestData newQuestData = QuestDataCapability.get(player);
        QuestDataCapability.INSTANCE.readNBT((Object)newQuestData, null, (INBT)nbt);
        IChallengesData oldChallengeData = ChallengesDataCapability.get(original);
        nbt = ChallengesDataCapability.INSTANCE.writeNBT((Object)oldChallengeData, null);
        IChallengesData newChallengeData = ChallengesDataCapability.get(player);
        ChallengesDataCapability.INSTANCE.readNBT((Object)newChallengeData, null, (INBT)nbt);
        IAbilityData oldAbilityData = AbilityDataCapability.get((LivingEntity)original);
        nbt = AbilityDataCapability.INSTANCE.writeNBT((Object)oldAbilityData, null);
        IAbilityData newAbilityData = AbilityDataCapability.get((LivingEntity)player);
        AbilityDataCapability.INSTANCE.readNBT((Object)newAbilityData, null, (INBT)nbt);
        AbilityValidationEvents.validateUnlockedAbilities((LivingEntity)player);
        AttributeHelper.updateHPAttribute(player);
        player.func_70606_j(player.func_110138_aP());
        IEntityStats statsData = EntityStatsCapability.get((LivingEntity)player);
        statsData.setShadow(true);
        statsData.setStrawDoll(true);
        statsData.setHeart(true);
    }
}

