/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.events.SmithingTableEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.WantedPosterBlock;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEnchantments;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.DFEncyclopediaItem;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class CraftingEvents {
    private static final String CANVAS_SIZE_NBT = "canvasSize";

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (event.getCrafting().func_77973_b().equals(((Block)ModBlocks.FLAG.get()).func_199767_j())) {
            CraftingEvents.handleFlagUpgrades(event.getPlayer(), event.getCrafting(), event.getInventory());
        } else if (event.getCrafting().func_77973_b().equals(((Block)ModBlocks.WANTED_POSTER.get()).func_199767_j())) {
            CraftingEvents.handleWantedPosterUpgrades(event.getPlayer(), event.getCrafting(), event.getInventory());
        } else if (event.getCrafting().func_77973_b().equals(ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get())) {
            CraftingEvents.handleEncyclopediaMerge(event.getPlayer(), event.getCrafting(), event.getInventory());
        }
    }

    private static void handleEncyclopediaMerge(PlayerEntity player, ItemStack output, IInventory craftingMatrix) {
        for (int i = 0; i < craftingMatrix.func_70302_i_(); ++i) {
            ItemStack stack = craftingMatrix.func_70301_a(i);
            if (stack.func_77973_b() != ModItems.DEVIL_FRUIT_ENCYCLOPEDIA.get()) continue;
            for (DFEncyclopediaEntry entry : DFEncyclopediaItem.getEntries(stack)) {
                DFEncyclopediaItem.addFruitClues(output, entry.getDevilFruit().getRegistryName(), entry);
            }
        }
    }

    private static void handleWantedPosterUpgrades(PlayerEntity player, ItemStack output, IInventory craftingMatrix) {
        ItemStack originalStack = null;
        for (int slot = 0; slot < craftingMatrix.func_70302_i_(); ++slot) {
            boolean isFlag;
            ItemStack stack = craftingMatrix.func_70301_a(slot);
            if (stack == null || stack.func_190926_b() || !(isFlag = stack.func_77973_b().equals(((Block)ModBlocks.WANTED_POSTER.get()).func_199767_j()))) continue;
            originalStack = stack;
        }
        if (originalStack != null) {
            CompoundNBT nbt = originalStack.func_196082_o();
            CanvasSize size = CanvasSize.SMALL;
            if (!nbt.isEmpty()) {
                size = CanvasSize.values()[nbt.func_74762_e(CANVAS_SIZE_NBT)];
            }
            if (size.isMaximumSize()) {
                output.func_77982_d(originalStack.func_196082_o());
                WantedPosterBlock.setDetails(output, size);
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151121_aF.func_199767_j(), 8));
                return;
            }
            CanvasSize upgradeSize = CanvasSize.values()[size.ordinal() + 1];
            output.func_77982_d(originalStack.func_196082_o());
            WantedPosterBlock.setDetails(output, upgradeSize);
        }
    }

    private static void handleFlagUpgrades(PlayerEntity player, ItemStack output, IInventory craftingMatrix) {
        CompoundNBT nbt = null;
        for (int slot = 0; slot < craftingMatrix.func_70302_i_(); ++slot) {
            boolean isFlag;
            ItemStack stack = craftingMatrix.func_70301_a(slot);
            if (stack == null || stack.func_190926_b() || !(isFlag = stack.func_77973_b().equals(((Block)ModBlocks.FLAG.get()).func_199767_j()))) continue;
            nbt = stack.func_196082_o();
        }
        if (nbt != null) {
            CanvasSize size = CanvasSize.SMALL;
            if (!nbt.isEmpty()) {
                size = CanvasSize.values()[nbt.func_74762_e(CANVAS_SIZE_NBT)];
            }
            if (size.isMaximumSize()) {
                FlagBlock.setDetails(output, size);
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_221603_aE.func_199767_j(), 8));
                return;
            }
            CanvasSize upgradeSize = CanvasSize.values()[size.ordinal() + 1];
            FlagBlock.setDetails(output, upgradeSize);
        }
    }

    @SubscribeEvent
    public static void onSmithingUpdate(SmithingTableEvent event) {
        if (ItemsHelper.isBow(event.getBaseSlot())) {
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.FLAME_DIAL.get()).func_199767_j(), Enchantments.field_185311_w, 1, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.BREATH_DIAL.get()).func_199767_j(), Enchantments.field_185310_v, 1, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.EISEN_DIAL.get()).func_199767_j(), Enchantments.field_185309_u, 1, 3);
        } else if (ItemsHelper.isSword(event.getBaseSlot())) {
            CraftingEvents.applyEnchantment(event, (Item)ModItems.KAIROSEKI.get(), (Enchantment)ModEnchantments.KAIROSEKI.get(), 1, 10);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.FLAME_DIAL.get()).func_199767_j(), Enchantments.field_77334_n, 3, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.EISEN_DIAL.get()).func_199767_j(), Enchantments.field_185302_k, 3, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.FLASH_DIAL.get()).func_199767_j(), (Enchantment)ModEnchantments.DIAL_FLASH.get(), 3, 3);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.IMPACT_DIAL.get()).func_199767_j(), (Enchantment)ModEnchantments.DIAL_IMPACT.get(), 2, 5);
            CraftingEvents.applyEnchantment(event, ((Block)ModBlocks.BREATH_DIAL.get()).func_199767_j(), Enchantments.field_180313_o, 3, 3);
        }
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151008_G, 1, 8, new ItemStack((IItemProvider)ModBlocks.BREATH_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151145_ak, 1, 10, new ItemStack((IItemProvider)ModBlocks.AXE_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151042_j, 1, 8, new ItemStack((IItemProvider)ModBlocks.EISEN_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151065_br, 1, 6, new ItemStack((IItemProvider)ModBlocks.FLAME_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151114_aO, 1, 10, new ItemStack((IItemProvider)ModBlocks.FLASH_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)Items.field_151016_H, 1, 10, new ItemStack((IItemProvider)ModBlocks.IMPACT_DIAL.get()));
        CraftingEvents.craftDial(event, (IItemProvider)Items.field_205157_eZ, (IItemProvider)ModBlocks.SKY_BLOCK.get(), 1, 4, new ItemStack((IItemProvider)ModBlocks.MILKY_DIAL.get()));
    }

    private static void craftDial(SmithingTableEvent event, IItemProvider base, IItemProvider add, int baseQty, int addQty, ItemStack result) {
        if (event.getBaseSlot().func_77973_b().equals(base.func_199767_j()) && event.getBaseSlot().func_190916_E() >= baseQty && event.getAdditionSlot().func_77973_b().equals(add.func_199767_j()) && event.getAdditionSlot().func_190916_E() >= addQty) {
            event.setResultRecipe(result, baseQty, addQty);
        }
    }

    private static void applyEnchantment(SmithingTableEvent event, Item enchItem, Enchantment ench, int maxLevel, int addQty) {
        int enchLevel = EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)event.getBaseSlot());
        if (enchLevel >= maxLevel) {
            return;
        }
        if (event.getAdditionSlot().func_77973_b() == enchItem && event.getAdditionSlot().func_190916_E() >= addQty && event.getAdditionSlot().func_190916_E() / addQty > enchLevel) {
            int level = event.getAdditionSlot().func_190916_E() / addQty;
            if (level > maxLevel) {
                level = maxLevel;
            }
            ItemStack stack = event.getBaseSlot().func_77946_l();
            Map map = EnchantmentHelper.func_82781_a((ItemStack)event.getBaseSlot());
            if (map.containsKey(ench)) {
                map.replace(ench, level);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
            } else {
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
                stack.func_77966_a(ench, level);
            }
            event.setResultRecipe(stack, 1, addQty);
        }
    }
}

