/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.effects.IBindHandsEffect;
import xyz.pixelatedw.mineminenomi.api.effects.IBreakableEffect;
import xyz.pixelatedw.mineminenomi.api.effects.IChangeSwingSpeedEffect;
import xyz.pixelatedw.mineminenomi.api.effects.IDisableAbilitiesEffect;
import xyz.pixelatedw.mineminenomi.api.effects.IIgnoreMilkEffect;
import xyz.pixelatedw.mineminenomi.api.effects.ILinkedEffect;
import xyz.pixelatedw.mineminenomi.api.effects.ITransmisibleByProximityEffect;
import xyz.pixelatedw.mineminenomi.api.effects.ITransmisibleByTouchEffect;
import xyz.pixelatedw.mineminenomi.api.effects.IVanishEffect;
import xyz.pixelatedw.mineminenomi.api.events.EntityCarryEvent;
import xyz.pixelatedw.mineminenomi.api.events.PotionAfterAddedEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingHurtEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.effects.GuardingEffect;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class EffectsEvents {

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class Client {
        @SubscribeEvent
        public static void onEntityRendered(RenderLivingEvent.Pre event) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity clientPlayer = mc.field_71439_g;
            boolean isAuraHakiActive = false;
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)clientPlayer);
            if (abilityProps != null) {
                KenbunshokuHakiAuraAbility auraHaki = abilityProps.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
                isAuraHakiActive = auraHaki != null && auraHaki.isContinuous();
            }
            LivingEntity entity = event.getEntity();
            Iterator iter = entity.func_70651_bq().iterator();
            while (iter.hasNext()) {
                EffectInstance eff = (EffectInstance)iter.next();
                if (eff.func_76459_b() <= 0) {
                    iter.remove();
                }
                if (!(eff.func_188419_a() instanceof IVanishEffect) || !((IVanishEffect)eff.func_188419_a()).isVanished(entity, eff.func_76459_b(), eff.func_76458_c()) || isAuraHakiActive && entity != clientPlayer) continue;
                event.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent
        public static void onMouseClicked(InputEvent.ClickInputEvent event) {
            if (event.getHand() == Hand.MAIN_HAND) {
                Minecraft mc = Minecraft.func_71410_x();
                ClientPlayerEntity player = mc.field_71439_g;
                player.func_70651_bq().stream().map(EffectInstance::func_188419_a).filter(IBindHandsEffect.class::isInstance).filter(eff -> ((IBindHandsEffect)eff).isBlockingSwings()).forEach(eff -> {
                    event.setCanceled(true);
                    event.setSwingHand(false);
                });
            }
        }

        @SubscribeEvent
        public static void onHandRendering(RenderHandEvent event) {
            if (event.getHand() != Hand.MAIN_HAND) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player.func_70644_a((Effect)ModEffects.NO_HANDS.get())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onShocked(EntityViewRenderEvent.CameraSetup event) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (!player.func_70644_a((Effect)ModEffects.DIZZY.get())) {
                return;
            }
            if (player.func_70660_b((Effect)ModEffects.DIZZY.get()).func_76459_b() <= 0) {
                player.func_195063_d((Effect)ModEffects.DIZZY.get());
                return;
            }
            if (mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON) {
                event.setRoll((float)Math.sin(player.field_70173_aa % 100));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class Common {
        @SubscribeEvent
        public static void onMountEffects(EntityMountEvent event) {
            if (event.getEntityBeingMounted() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)event.getEntityBeingMounted();
                if (event.isMounting()) {
                    Common.tryLinkEffectsWithPassangers(entity);
                } else {
                    Common.tryUnlinkEffectsWithPassangers(entity);
                }
            }
        }

        @SubscribeEvent
        public static void onCarryEffects(EntityCarryEvent event) {
            if (event.isCarrying()) {
                Common.tryLinkEffectsWithPassangers(event.getEntityLiving());
            } else {
                Common.tryUnlinkEffectsWithPassangers(event.getEntityLiving());
            }
        }

        private static void tryUnlinkEffectsWithPassangers(LivingEntity entity) {
            for (EffectInstance effect : entity.func_70651_bq()) {
                if (!(effect.func_188419_a() instanceof ILinkedEffect)) continue;
                for (Entity passanger : entity.func_184188_bt()) {
                    if (passanger == null || !passanger.func_70089_S() || !(passanger instanceof LivingEntity)) continue;
                    ((LivingEntity)passanger).func_195063_d(effect.func_188419_a());
                }
                IEntityStats props = EntityStatsCapability.get(entity);
                if (!props.isCarrying()) continue;
                props.getCarry().func_195063_d(effect.func_188419_a());
            }
        }

        private static void tryLinkEffectsWithPassangers(LivingEntity entity) {
            for (EffectInstance effect : entity.func_70651_bq()) {
                boolean isTransmisibleByTouch = effect.func_188419_a() instanceof ITransmisibleByTouchEffect && ((ITransmisibleByTouchEffect)effect.func_188419_a()).isTransmisibleByTouch();
                boolean isLinked = effect.func_188419_a() instanceof ILinkedEffect;
                if (!isTransmisibleByTouch && !isLinked) continue;
                EffectInstance newEffect = new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e(), effect.func_205348_f());
                for (Entity passanger : entity.func_184188_bt()) {
                    if (passanger == null || !passanger.func_70089_S() || !(passanger instanceof LivingEntity)) continue;
                    ((LivingEntity)passanger).func_195064_c(newEffect);
                }
                IEntityStats props = EntityStatsCapability.get(entity);
                if (!props.isCarrying()) continue;
                props.getCarry().func_195064_c(newEffect);
            }
        }

        @SubscribeEvent
        public static void projectileImpactEvent(ProjectileImpactEvent.Throwable event) {
            ItemStack potion;
            List effects;
            EntityRayTraceResult entityHit;
            if (event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && (entityHit = (EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof LivingEntity && event.getThrowable() instanceof PotionEntity && (effects = PotionUtils.func_185189_a((ItemStack)(potion = ((PotionEntity)event.getThrowable()).func_184543_l()))).isEmpty()) {
                LivingEntity entity = (LivingEntity)entityHit.func_216348_a();
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.WET.get(), 60, 0, false, false));
            }
        }

        @SubscribeEvent
        public static void onItemConsumed(LivingEntityUseItemEvent.Finish event) {
            if (!event.getItem().func_190926_b() && event.getEntityLiving().func_70644_a((Effect)ModEffects.DEHYDRATION.get())) {
                boolean isWaterBottle;
                Item item = event.getItem().func_77973_b();
                boolean bl = isWaterBottle = PotionUtils.func_185191_c((ItemStack)event.getItem()) == Potions.field_185230_b;
                if (item == Items.field_151117_aB || item == ModItems.COLA.get() || item == ModItems.ULTRA_COLA.get() || isWaterBottle) {
                    EffectInstance inst = event.getEntityLiving().func_70660_b((Effect)ModEffects.DEHYDRATION.get());
                    if (inst.func_76458_c() == 0) {
                        event.getEntityLiving().func_195063_d((Effect)ModEffects.DEHYDRATION.get());
                    } else {
                        int newAmp = inst.func_76458_c() - 1;
                        ((EffectInstanceMixin)inst).setAmplifier(newAmp);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onPotionAdded(PotionAfterAddedEvent event) {
            LivingEntity entity = event.getEntityLiving();
            EffectInstance inst = event.getPotionEffect();
            if (inst.func_188419_a() instanceof IDisableAbilitiesEffect) {
                Predicate<IAbility> check = ((IDisableAbilitiesEffect)inst.func_188419_a()).getDisabledAbilities();
                AbilityHelper.disableAbilities(entity, inst.func_76459_b(), check);
            }
            Common.tryLinkEffectsWithPassangers(entity);
            Common.trySpreadProximityEffect(entity, inst);
        }

        public static void trySpreadProximityEffect(LivingEntity entity, EffectInstance inst) {
            if (inst.func_188419_a() instanceof ITransmisibleByProximityEffect && ((ITransmisibleByProximityEffect)inst.func_188419_a()).isTransmisibleByProximity()) {
                float distance = ((ITransmisibleByProximityEffect)inst.func_188419_a()).poximityTransmisionDistance();
                List<LivingEntity> targets = TargetHelper.getEntitiesInArea(entity, (double)distance, TargetsPredicate.EVERYTHING, LivingEntity.class);
                for (LivingEntity target : targets) {
                    if (target.func_70644_a(inst.func_188419_a())) continue;
                    EffectInstance newEffect = new EffectInstance(inst.func_188419_a().getEffect(), inst.func_76459_b(), inst.func_76458_c(), inst.func_82720_e(), inst.func_188418_e(), inst.func_205348_f());
                    target.func_195064_c(newEffect);
                }
            }
        }

        @SubscribeEvent
        public static void onPotionExpires(PotionEvent.PotionExpiryEvent event) {
            LivingEntity entity = event.getEntityLiving();
            EffectInstance effect = event.getPotionEffect();
            if (effect == null) {
                return;
            }
            if (effect.func_188419_a() == ModEffects.DRUNK.get()) {
                IEntityStats props = EntityStatsCapability.get(entity);
                entity.func_70097_a((DamageSource)ModDamageSource.STORED_DAMAGE, props.getStoredDamage());
                props.setStoredDamage(0.0f);
            }
            if (effect.func_188419_a() instanceof IDisableAbilitiesEffect) {
                Predicate<IAbility> check = ((IDisableAbilitiesEffect)effect.func_188419_a()).getDisabledAbilities();
                AbilityHelper.enableAbilities(entity, check);
            }
            Common.tryUnlinkEffectsWithPassangers(entity);
        }

        @SubscribeEvent
        public static void onPotionRemoved(PotionEvent.PotionRemoveEvent event) {
            boolean isMilkBucket;
            LivingEntity entity = event.getEntityLiving();
            EffectInstance effect = event.getPotionEffect();
            if (entity.func_184600_cs() == null) {
                return;
            }
            boolean bl = isMilkBucket = entity.func_184586_b(entity.func_184600_cs()).func_77973_b() == Items.field_151117_aB;
            if (isMilkBucket && event.getPotion() instanceof IIgnoreMilkEffect && !((IIgnoreMilkEffect)event.getPotion()).isRemoveable()) {
                event.setCanceled(true);
            }
            if (effect == null) {
                return;
            }
            if (effect.func_188419_a() instanceof IDisableAbilitiesEffect) {
                Predicate<IAbility> check = ((IDisableAbilitiesEffect)effect.func_188419_a()).getDisabledAbilities();
                AbilityHelper.enableAbilities(entity, check);
            }
            Common.tryUnlinkEffectsWithPassangers(entity);
        }

        @SubscribeEvent
        public static void onPlayerBreakSpeed(PlayerEvent.BreakSpeed event) {
            PlayerEntity player = event.getPlayer();
            for (EffectInstance effectInstance : player.func_70651_bq()) {
                if (!(effectInstance.func_188419_a() instanceof IChangeSwingSpeedEffect)) continue;
                float newSwingSpeed = ((IChangeSwingSpeedEffect)effectInstance.func_188419_a()).swingSpeedModifier(effectInstance.func_76459_b(), effectInstance.func_76458_c());
                event.setNewSpeed(event.getOriginalSpeed() / newSwingSpeed);
            }
        }

        public static float applyBreakableEffectDamage(Entity sourceEntity, LivingEntity target, float amount, List<Effect> breakableEffects) {
            float highestMultiplier = 1.0f;
            if (sourceEntity != null) {
                for (Effect effect : breakableEffects) {
                    if (effect == null || !(effect instanceof IBreakableEffect) || !target.func_70644_a(effect)) continue;
                    target.func_195063_d(effect);
                    float currentMultiplier = ((IBreakableEffect)effect.getEffect()).getBreakingMultiplier();
                    if (!(currentMultiplier > highestMultiplier)) continue;
                    highestMultiplier = currentMultiplier;
                }
            }
            return amount * highestMultiplier;
        }

        @SubscribeEvent
        public static void onEntityHurt(WyLivingHurtEvent event) {
            LivingEntity entity = event.getEntityLiving();
            Entity source = event.getSource().func_76346_g();
            for (EffectInstance effectInstance : entity.func_70651_bq()) {
                if (!(effectInstance.func_188419_a() instanceof GuardingEffect)) continue;
                GuardingEffect instance = (GuardingEffect)effectInstance.func_188419_a();
                if (instance.useOnlySources && !instance.acceptableSources.contains(event.getSource().func_76355_l())) {
                    return;
                }
                if (event.getSource().func_151517_h()) {
                    return;
                }
                if (instance.reduceSpeedAfterHit) {
                    Effect effect = (Effect)ModEffects.MOVEMENT_BLOCKED.get();
                    entity.getClass();
                    entity.func_195064_c(new EffectInstance(effect, 20 / 2, 1, false, false));
                }
                float power = ((float)effectInstance.func_76458_c() + 1.0f) * 2.5f;
                power *= event.getSource().func_76363_c() ? 0.8f : 1.0f;
                if (event.getAmount() < power) {
                    entity.func_213293_j(0.0, 0.0, 0.0);
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                } else {
                    event.setAmount(event.getAmount() - power);
                }
                return;
            }
            Iterator iter = entity.func_70651_bq().iterator();
            while (iter.hasNext()) {
                EffectInstance effectInstance;
                effectInstance = (EffectInstance)iter.next();
                if (effectInstance.func_188419_a() != ModEffects.OIL_COVERED.get() || !event.getSource().func_76347_k()) continue;
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 4.0f);
                explosion.setStaticDamage(40.0f);
                explosion.setFireAfterExplosion(true);
                explosion.setSmokeParticles(new CommonExplosionParticleEffect(4));
                explosion.doExplosion();
                iter.remove();
                entity.func_184102_h().func_184103_al().func_148543_a(null, entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c, 100.0, entity.func_130014_f_().func_234923_W_(), (IPacket)new SRemoveEntityEffectPacket(entity.func_145782_y(), (Effect)ModEffects.OIL_COVERED.get()));
            }
        }
    }
}

