/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FightingStyleHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class FightingStylesEvents {
    @SubscribeEvent
    public static void onAttributesChange(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (event.getSlotType() == EquipmentSlotType.MAINHAND && !stack.func_190926_b() && ItemsHelper.isSword(stack) && stack.func_77942_o()) {
            AttributeModifier mod = new AttributeModifier(FightingStyleHelper.SWORDSMAN_ATTACK_BONUS_ID, "Swordsman Bonus", 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
            if (stack.func_77978_p().func_74767_n("hasSwordsmanBonus")) {
                event.addModifier(Attributes.field_233823_f_, mod);
            } else if (!stack.func_77978_p().func_74767_n("hasSwordsmanBonus")) {
                event.removeModifier(Attributes.field_233823_f_, mod);
            }
        }
    }

    @SubscribeEvent
    public static void onItemChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = event.getTo();
        if (!stack.func_190926_b() && ItemsHelper.isSword(stack)) {
            if (!stack.func_77942_o()) {
                stack.func_196082_o();
            }
            if (EntityStatsCapability.get(entity).isSwordsman()) {
                stack.func_77978_p().func_74757_a("hasSwordsmanBonus", true);
            } else {
                stack.func_77978_p().func_82580_o("hasSwordsmanBonus");
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onTooltipRender(ItemTooltipEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (ItemsHelper.isSword(event.getItemStack()) && EntityStatsCapability.get((LivingEntity)event.getPlayer()).isSwordsman()) {
            StringTextComponent damageBonus = new StringTextComponent(TextFormatting.GREEN + "" + new TranslationTextComponent(ModI18n.ITEM_SWORDSMAN_BONUS).getString());
            if (!event.getToolTip().contains(damageBonus)) {
                event.getToolTip().add(new StringTextComponent(""));
                event.getToolTip().add(damageBonus);
            }
        }
    }

    @SubscribeEvent
    public static void onStatsChoose(SetPlayerDetailsEvent event) {
        FightingStyleHelper.removeBrawlerModifiers((LivingEntity)event.getPlayer());
        FightingStyleHelper.removeBlackLegModifiers((LivingEntity)event.getPlayer());
        if (event.getEntityStats().isBlackLeg()) {
            FightingStyleHelper.applyBlackLegModifiers((LivingEntity)event.getPlayer());
        }
        if (event.getEntityStats().isBrawler()) {
            FightingStyleHelper.applyBrawlerModifiers((LivingEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void edgeCasesChecks(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side != LogicalSide.SERVER || event.player.field_70173_aa % 10 != 0) {
            return;
        }
        PlayerEntity player = event.player;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        boolean isHandEmpty = player.func_184614_ca().func_190926_b();
        if (props.isBlackLeg()) {
            double appliedBonus;
            double possibleBonus;
            if (!isHandEmpty && FightingStyleHelper.hasBlackLegModifiers((LivingEntity)player)) {
                FightingStyleHelper.removeBrawlerModifiers((LivingEntity)player);
            }
            if ((possibleBonus = FightingStyleHelper.getBlackLegBonus((LivingEntity)player)) != (appliedBonus = FightingStyleHelper.getAppliedBlackLegBonus((LivingEntity)player))) {
                FightingStyleHelper.applyBlackLegModifiers((LivingEntity)player);
            }
        } else if (props.isBrawler()) {
            double appliedBonus;
            double possibleBonus;
            if (!isHandEmpty && FightingStyleHelper.hasBrawlerModifiers((LivingEntity)player)) {
                FightingStyleHelper.removeBrawlerModifiers((LivingEntity)player);
            }
            if ((possibleBonus = FightingStyleHelper.getBrawlerBonus((LivingEntity)player)) != (appliedBonus = FightingStyleHelper.getAppliedBrawlerBonus((LivingEntity)player))) {
                FightingStyleHelper.applyBrawlerModifiers((LivingEntity)player);
            }
        } else {
            if (FightingStyleHelper.hasBrawlerModifiers((LivingEntity)player)) {
                FightingStyleHelper.removeBrawlerModifiers((LivingEntity)player);
            }
            if (FightingStyleHelper.hasBlackLegModifiers((LivingEntity)player)) {
                FightingStyleHelper.removeBlackLegModifiers((LivingEntity)player);
            }
        }
    }
}

