/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiFutureSightAbility;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingHurtEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class HakiGainEvents {
    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
            float hakiMultiplier = (float)CommonConfig.INSTANCE.getHakiExpMultiplier();
            boolean isKnockedDown = false;
            if (player.func_70644_a((Effect)ModEffects.UNCONSCIOUS.get())) {
                isKnockedDown = true;
            }
            if (isKnockedDown) {
                return;
            }
            KenbunshokuHakiFutureSightAbility ability = props.getEquippedAbility(KenbunshokuHakiFutureSightAbility.INSTANCE);
            if (ability != null && ability.isContinuous() && hakiProps.getKenbunshokuHakiExp() >= 60.0f && player.field_70173_aa % 600 == 0) {
                float finalHakiExp = 0.025f * hakiMultiplier;
                hakiProps.alterKenbunshokuHakiExp(finalHakiExp, StatChangeSource.NATURAL);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(WyLivingHurtEvent event) {
        AbilityProjectileEntity entity;
        if (event.getAmount() < 1.0f || !(event.getEntityLiving() instanceof PlayerEntity) || !(event.getSource().func_76346_g() instanceof LivingEntity) || event.getEntityLiving().field_70170_p.field_72995_K || event.getSource().func_94541_c()) {
            return;
        }
        if (event.getSource().func_76364_f() instanceof AbilityProjectileEntity && !(entity = (AbilityProjectileEntity)event.getSource().func_76364_f()).isPhysical()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        boolean isKnockedDown = false;
        if (player.func_70644_a((Effect)ModEffects.UNCONSCIOUS.get())) {
            isKnockedDown = true;
        }
        if (isKnockedDown) {
            return;
        }
        KenbunshokuHakiAuraAbility ability = abilityProps.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        if (ability != null && ability.isContinuous() || (double)hakiProps.getKenbunshokuHakiExp() <= 30.0 + HakiHelper.getKenbunshokuAuraExpNeeded((LivingEntity)player)) {
            float exp = event.getAmount() / (20.0f + 100.0f * (hakiProps.getKenbunshokuHakiExp() / 100.0f));
            if (exp <= 0.0f) {
                exp = 1.0E-5f;
            }
            float finalHakiExp = exp * (float)CommonConfig.INSTANCE.getHakiExpMultiplier();
            hakiProps.alterKenbunshokuHakiExp(finalHakiExp, StatChangeSource.NATURAL);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        AbilityProjectileEntity entity;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = null;
        boolean isHardeningDamage = false;
        boolean isImbuingDamage = false;
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            player = (PlayerEntity)event.getSource().func_76346_g();
            ItemStack heldStack = player.func_184614_ca();
            isHardeningDamage = heldStack.func_190926_b();
            isImbuingDamage = HakiHelper.isItemAffectedByImbuing(heldStack);
        } else if (event.getSource().func_76346_g() instanceof AbilityProjectileEntity && (entity = (AbilityProjectileEntity)event.getSource().func_76346_g()).getThrower() instanceof PlayerEntity && entity.isPhysical()) {
            player = (PlayerEntity)entity.getThrower();
            isHardeningDamage = entity.isAffectedByHaki();
            isImbuingDamage = entity.isAffectedByImbuing();
        }
        if (player == null) {
            return;
        }
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        ModifiableAttributeInstance attrAtk = event.getEntityLiving().func_233645_dx_().func_233779_a_(Attributes.field_233823_f_);
        ModifiableAttributeInstance attrHP = event.getEntityLiving().func_233645_dx_().func_233779_a_(Attributes.field_233818_a_);
        double atk = attrAtk != null ? attrAtk.func_111125_b() : 0.0;
        double hp = attrHP != null ? attrHP.func_111125_b() : 0.0;
        float expValue = (float)(atk + hp);
        int mult = 2;
        boolean flag = false;
        if (event.getSource() instanceof AbilityDamageSource) {
            AbilityDamageSource ablSource = (AbilityDamageSource)event.getSource();
            isHardeningDamage &= ablSource.getHakiNature() == SourceHakiNature.HARDENING;
            isImbuingDamage &= ablSource.getHakiNature() == SourceHakiNature.IMBUING;
        }
        if (isHardeningDamage || isImbuingDamage) {
            if (expValue < hakiProps.getBusoshokuHakiExp()) {
                mult = 10;
            }
            boolean hasHardeningActive = HakiHelper.hasHardeningActive((LivingEntity)player);
            boolean hasImbuingActive = HakiHelper.hasImbuingActive((LivingEntity)player);
            if (hasHardeningActive || hasImbuingActive || (double)hakiProps.getBusoshokuHakiExp() <= 30.0 + HakiHelper.getBusoshokuHardeningExpNeeded((LivingEntity)player)) {
                flag = true;
            }
        }
        if (flag) {
            StatChangeSource source = event.getEntityLiving() instanceof PlayerEntity ? StatChangeSource.KILL_PLAYER : StatChangeSource.KILL_NPC;
            float exp = HakiGainEvents.getFinalHakiExp(expValue, mult, hakiProps);
            float finalHakiExp = (float)((double)exp * CommonConfig.INSTANCE.getHakiExpMultiplier());
            hakiProps.alterBusoshokuHakiExp(finalHakiExp, source);
        }
    }

    private static final float getFinalHakiExp(float val, int multiplier, IHakiData data) {
        float currentHaki = data.getBusoshokuHakiExp();
        float finalExp = val * ((float)CommonConfig.INSTANCE.getHakiExpLimit() - currentHaki) / (float)multiplier / 10000.0f;
        return Math.max(0.001f, finalExp);
    }
}

