/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.haki.HaoshokuHakiInfusionAbility;
import xyz.pixelatedw.mineminenomi.api.events.ProjectileShootEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.IProjectileExtras;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.ProjectileExtrasCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncProjectileExtrasPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class ProjectileEntityEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof ProjectileEntity && !(event.getTarget() instanceof AbilityProjectileEntity)) {
            ProjectileEntity proj = (ProjectileEntity)event.getTarget();
            ProjectileEntityEvents.setProjectileHakiData(proj, proj.func_234616_v_());
        }
    }

    @SubscribeEvent
    public static void onProjectileShoot(ProjectileShootEvent event) {
        AbilityProjectileEntity proj = event.getProjectile();
        if (proj == null || proj.getThrower() == null) {
            return;
        }
        IProjectileExtras props = ProjectileExtrasCapability.get((Entity)proj);
        if (props == null) {
            return;
        }
        LivingEntity thrower = proj.getThrower();
        ProjectileEntityEvents.setProjectileHakiData((ProjectileEntity)proj, (Entity)thrower);
        props.setWeaponUsed(thrower.func_184614_ca());
    }

    private static void setProjectileHakiData(ProjectileEntity proj, Entity owner) {
        if (owner == null || !(owner instanceof LivingEntity)) {
            return;
        }
        LivingEntity thrower = (LivingEntity)owner;
        IProjectileExtras projectileExtrasProps = ProjectileExtrasCapability.get((Entity)proj);
        IAbilityData abilityDataProps = AbilityDataCapability.get(thrower);
        if (projectileExtrasProps == null || abilityDataProps == null) {
            return;
        }
        HaoshokuHakiInfusionAbility haoshokuHakiInfusion = abilityDataProps.getEquippedAbility(HaoshokuHakiInfusionAbility.INSTANCE);
        boolean hasBusoshokuImbuingActive = HakiHelper.hasImbuingActive(thrower, false, false);
        boolean hasBusoshokuShroudingActive = HakiHelper.hasAdvancedBusoActive(thrower);
        boolean hasHaoshokuInfusionActive = haoshokuHakiInfusion != null && haoshokuHakiInfusion.isContinuous();
        projectileExtrasProps.setProjectileBusoshokuImbued(hasBusoshokuImbuingActive);
        projectileExtrasProps.setProjectileBusoshokuShrouded(hasBusoshokuShroudingActive);
        projectileExtrasProps.setProjectileHaoshokuInfused(hasHaoshokuInfusionActive);
        float piercing = 0.0f;
        if (proj instanceof AbilityProjectileEntity) {
            piercing = ((AbilityProjectileEntity)proj).getArmorPiercing();
        }
        float f = piercing = HakiHelper.hasBusoInternalDestructionActive(thrower) ? 1.0f : piercing;
        if (proj instanceof AbilityProjectileEntity) {
            ((AbilityProjectileEntity)proj).setArmorPiercing(piercing);
        }
        projectileExtrasProps.setPiercing(piercing);
        if (!proj.field_70170_p.field_72995_K && owner instanceof PlayerEntity) {
            WyNetwork.sendToAllTrackingAndSelf(new SSyncProjectileExtrasPacket(proj), (LivingEntity)((PlayerEntity)thrower));
        }
    }
}

