/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.loot.LootTable;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.DoppelmanEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.MirageCloneEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.NightmareSoldierEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.WaxCloneEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class StatsGainEvents {
    public static void giveStats(LivingEntity target, DamageSource source) {
        if (target.field_70170_p.field_72995_K) {
            return;
        }
        if (!CommonConfig.INSTANCE.isMobRewardsEnabled()) {
            return;
        }
        if (WyHelper.isInChallengeDimension(target.field_70170_p)) {
            return;
        }
        PlayerEntity player = null;
        if (source.func_76346_g() instanceof PlayerEntity) {
            player = (PlayerEntity)source.func_76346_g();
        } else if (source instanceof AbilityDamageSource && source.func_76364_f() instanceof PlayerEntity) {
            player = (PlayerEntity)source.func_76364_f();
        }
        if (player == null) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        ModifiableAttributeInstance attrAtk = target.func_233645_dx_().func_233779_a_(Attributes.field_233823_f_);
        ModifiableAttributeInstance attrHP = target.func_233645_dx_().func_233779_a_(Attributes.field_233818_a_);
        long plusBelly = 0L;
        long plusBounty = 0L;
        double plusDoriki = 0.0;
        StatChangeSource statSource = StatChangeSource.KILL_NPC;
        IEntityStats targetprops = EntityStatsCapability.get(target);
        if (props.isMarine() && (targetprops.isMarine() || targetprops.isBountyHunter())) {
            player.func_146105_b(ModI18n.INFO_LOYALTY_DROPPED, true);
            StatChangeSource loyaltySource = target instanceof PlayerEntity ? StatChangeSource.KILL_PLAYER : StatChangeSource.KILL_NPC;
            props.alterLoyalty(-0.5, loyaltySource);
        }
        if (target instanceof PlayerEntity) {
            double dorikiLost = targetprops.getDoriki() - WyHelper.percentage(CommonConfig.INSTANCE.getDorikiKeepPercentage(), targetprops.getDoriki());
            plusDoriki = dorikiLost / 4.0;
            double bountyLost = (double)targetprops.getBounty() - WyHelper.percentage(CommonConfig.INSTANCE.getBountyKeepPercentage(), targetprops.getBounty());
            plusBounty = (long)(bountyLost / 2.0);
            double bellyLost = (double)targetprops.getBelly() - WyHelper.percentage(CommonConfig.INSTANCE.getBellyKeepPercentage(), targetprops.getBelly());
            plusBelly = (long)bellyLost;
            statSource = StatChangeSource.KILL_PLAYER;
        } else {
            if (target instanceof DoppelmanEntity || target instanceof NightmareSoldierEntity || target instanceof MirageCloneEntity || target instanceof BlackKnightEntity || target instanceof WaxCloneEntity) {
                return;
            }
            if (props.isMarine() && targetprops.isMarine()) {
                return;
            }
            if (props.isRevolutionary() && targetprops.isRevolutionary()) {
                return;
            }
            LootTable loottable = target.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(target.func_213346_cF());
            if (loottable.getPool("mineminenomi:stats") != null) {
                return;
            }
            if (targetprops.getDoriki() > 0.0) {
                plusDoriki = targetprops.getDoriki() / 100.0;
                if (props.getDoriki() > targetprops.getDoriki()) {
                    plusDoriki = targetprops.getDoriki() / 10000.0;
                }
                if (plusDoriki < 1.0 && CommonConfig.INSTANCE.isMinimumDorikiPerKillEnabled()) {
                    plusDoriki = 1.0;
                }
                plusBounty = (long)targetprops.getDoriki() / 20L;
                plusBelly = targetprops.getBelly();
            } else if (attrAtk != null && attrHP != null) {
                double i = attrAtk.func_111125_b();
                double j = attrHP.func_111125_b();
                double targetDoriki = (int)Math.round((i + j) / 4.0);
                if (props.getDoriki() / 100.0 > targetDoriki) {
                    if (CommonConfig.INSTANCE.isMinimumDorikiPerKillEnabled()) {
                        plusDoriki = 1.0;
                    }
                } else {
                    plusDoriki = targetDoriki;
                }
                plusBounty = (int)Math.round((i + j) / 10.0);
                plusBelly = 1L;
            } else if (target instanceof VillagerEntity) {
                plusBounty = 250L;
            } else {
                plusDoriki = 0.0;
                plusBounty = 1L;
            }
            plusDoriki *= CommonConfig.INSTANCE.getDorikiRewardMultiplier();
            plusBounty = (long)((double)plusBounty * CommonConfig.INSTANCE.getBountyRewardMultiplier());
            plusBelly = (long)((double)plusBelly * CommonConfig.INSTANCE.getBellyRewardMultiplier());
            statSource = StatChangeSource.KILL_NPC;
        }
        if (plusDoriki > 0.0) {
            props.alterDoriki(plusDoriki, statSource);
        }
        if (BountyHelper.canGainBounty(player) && plusBounty > 0L) {
            props.alterBounty(plusBounty, statSource);
        }
        if (plusBelly > 0L) {
            props.alterBelly(plusBelly, statSource);
        }
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
    }
}

