/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.world.Difficulty;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.entities.TraderEntity;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class StructuresEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            StructuresHelper.SPAWNED_STRUCTURES.clear();
        }
    }

    @SubscribeEvent
    public static void onChestOpened(PlayerContainerEvent.Open event) {
        PlayerEntity player = event.getPlayer();
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        StructuresHelper.StructureFaction faction = StructuresHelper.StructureFaction.from(props.getFaction());
        if (faction == null) {
            return;
        }
        boolean isInisdeStruct = StructuresHelper.isInsideModStructure((ServerWorld)player.field_70170_p, player.func_233580_cy_(), faction);
        if (player.field_70170_p.field_72995_K || player.func_184812_l_() || player.func_175149_v() || !isInisdeStruct) {
            return;
        }
        if (player.func_70644_a((Effect)ModEffects.SILENT.get())) {
            return;
        }
        double range = player.field_70170_p.func_175659_aa() == Difficulty.HARD ? 64.0 : 32.0;
        List list = player.field_70170_p.func_217357_a(OPEntity.class, player.func_174813_aQ().func_186662_g(range)).stream().filter(e -> !(e instanceof TrainerEntity) && !(e instanceof TraderEntity)).collect(Collectors.toList());
        if (list.size() > 0) {
            if (props.isMarine() && props.getMarineRank().ordinal() < FactionHelper.MarineRank.CAPTAIN.ordinal()) {
                props.alterLoyalty(-0.25, StatChangeSource.NATURAL);
                WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
            }
            list.stream().forEach(entity -> entity.func_70624_b((LivingEntity)player));
        }
    }
}

