/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.abilities;

import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMountEntityPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.KnockdownAbility;
import xyz.pixelatedw.mineminenomi.abilities.RideableAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IChangeDamageSourceAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IOnDamageTakenAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PotionPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BowTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingAttackEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingDamageEvent;
import xyz.pixelatedw.mineminenomi.api.events.WyLivingHurtEvent;
import xyz.pixelatedw.mineminenomi.api.events.ability.EquipAbilityEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.commands.TestCommand;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.animation.AnimationDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.GCDCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.events.CombatModeEvents;
import xyz.pixelatedw.mineminenomi.events.EffectsEvents;
import xyz.pixelatedw.mineminenomi.events.StatsGainEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.packets.client.ability.components.CSwingTriggerPacket;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class AbilitiesEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onEquipAbility(EquipAbilityEvent event) {
        IAbility ability = event.getAbility();
        ability.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(component -> {
            component.addStartEvent(AuraLayer::addAbilityIcon);
            component.addEndEvent(AuraLayer::addAbilityIcon);
        });
        ability.getComponent(ModAbilityKeys.CHARGE).ifPresent(component -> {
            component.addStartEvent(AuraLayer::addAbilityIcon);
            component.addEndEvent(AuraLayer::addAbilityIcon);
        });
        ability.getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(component -> {
            component.addStartEvent(AuraLayer::addAbilityIcon);
            component.addEndEvent(AuraLayer::addAbilityIcon);
        });
        ability.getComponent(ModAbilityKeys.ANIME_SCREAM).ifPresent(component -> component.setupDefaultScreams(ability));
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.func_70089_S()) {
            return;
        }
        IAbilityData ablProps = AbilityDataCapability.get(entity);
        IEntityStats statsProps = EntityStatsCapability.get(entity);
        if (ablProps == null) {
            return;
        }
        GCDCapability.tickGCD(event.getEntityLiving());
        if (GCDCapability.isOnGCD(entity) && (Integer)GCDCapability.getGCD(entity).getKey() <= 0) {
            for (IAbility ability : ablProps.getEquippedAndPassiveAbilities()) {
                ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(comp -> comp.resetDecoration());
            }
        }
        if (!entity.field_70170_p.field_72995_K && statsProps.getInvulnerableTime() > 0) {
            statsProps.alterInvulnerableTime(-1);
        }
        if (!entity.field_70170_p.field_72995_K) {
            statsProps.tickLastAttack();
        }
        if (entity.field_70170_p.field_72995_K) {
            AnimationDataCapability.get(entity).tickAnimations();
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            WyDebug.showTPSInChat(player);
            if (!entity.field_70170_p.field_72995_K) {
                IChallengesData challengeProps = ChallengesDataCapability.get(player);
                challengeProps.tickInvitations();
            }
        }
        for (IAbility ability : ablProps.getEquippedAndPassiveAbilities()) {
            try {
                ability.tick(entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ItemStack stack : ItemsHelper.getAllInventoryItems(entity)) {
            ResourceLocation rs;
            AbilityCore<?> core;
            if (!stack.func_77942_o() || stack.func_77978_p().func_74779_i("spawnedByAbility") == null || (core = AbilityCore.get(rs = new ResourceLocation(stack.func_77978_p().func_74779_i("spawnedByAbility")))) == null) continue;
            Object abl = AbilityDataCapability.get(entity).getEquippedAbility(core);
            if (abl == null) {
                return;
            }
            if (!abl.hasComponent(ModAbilityKeys.ITEM_SPAWN) || abl.getComponent(ModAbilityKeys.ITEM_SPAWN).get().isActive()) continue;
            stack.func_190918_g(stack.func_77976_d());
        }
        if (entity.field_70173_aa % 10 == 0) {
            for (EffectInstance inst : entity.func_70651_bq()) {
                EffectsEvents.Common.trySpreadProximityEffect(entity, inst);
            }
        }
        TestCommand.runAllAbilityTests(entity);
    }

    @SubscribeEvent
    public static void onPlayerDies(LivingDeathEvent event) {
        PlayerEntity player;
        IAbilityData ablProps;
        LivingEntity living = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity directEntity = source.func_76364_f();
        Entity trueEntity = source.func_76346_g();
        LivingEntity attacker = null;
        if (directEntity != null && directEntity instanceof LivingEntity) {
            attacker = (LivingEntity)directEntity;
        } else if (trueEntity != null && trueEntity instanceof LivingEntity) {
            attacker = (LivingEntity)trueEntity;
        }
        StatsGainEvents.giveStats(living, source);
        if (event.getEntityLiving() instanceof PlayerEntity && (ablProps = AbilityDataCapability.get((LivingEntity)(player = (PlayerEntity)event.getEntityLiving()))) == null) {
            return;
        }
        AbilityHelper.disableAbilities(living, 10, (Predicate<IAbility>)Predicates.alwaysTrue());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAttackEvent(WyLivingHurtEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().field_70170_p.field_72995_K) {
            LivingEntity entity = event.getEntityLiving();
            Entity attacker = event.getSource().func_76346_g();
            DamageSource damageSource = event.getSource();
            IAbilityData ablProps = AbilityDataCapability.get(entity);
            IEntityStats props = EntityStatsCapability.get(entity);
            float amount = event.getAmount();
            if (ablProps == null) {
                return;
            }
            if (attacker instanceof LivingEntity) {
                boolean isFatalHit;
                props.setInCombatCache((LivingEntity)attacker);
                IAbilityData attackerProps = AbilityDataCapability.get((LivingEntity)attacker);
                boolean bl = isFatalHit = entity.func_110143_aJ() - amount <= 0.0f;
                if (isFatalHit) {
                    KnockdownAbility abl;
                    boolean isKnockdownActive = false;
                    if (attackerProps != null && (abl = attackerProps.getPassiveAbility(KnockdownAbility.INSTANCE)) != null) {
                        boolean bl2 = isKnockdownActive = !abl.getComponent(ModAbilityKeys.PAUSE_TICK).get().isPaused();
                    }
                    if (isKnockdownActive) {
                        entity.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 1800, 1));
                        entity.func_70606_j(2.0f);
                        entity.func_70066_B();
                        event.setCanceled(true);
                        return;
                    }
                }
            }
            if (attacker instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)attacker;
                IAbilityData attackerAbilityProps = AbilityDataCapability.get((LivingEntity)player);
                if (attackerAbilityProps == null) {
                    return;
                }
                boolean entityPunch = damageSource.func_76346_g() == player && (damageSource.func_76355_l().equalsIgnoreCase("player") || damageSource instanceof ModDamageSource && ((ModDamageSource)damageSource).isFistDamage());
                boolean meleeProjectile = damageSource.func_76364_f() instanceof AbilityProjectileEntity && damageSource instanceof AbilityDamageSource && ((AbilityDamageSource)damageSource).isFistDamage();
                double lastAttackThreshold = 8.0;
                ModifiableAttributeInstance attackSpeedAttr = player.func_110148_a(Attributes.field_233825_h_);
                if (attackSpeedAttr != null && !player.func_184614_ca().func_190926_b()) {
                    double attackSpeed = attackSpeedAttr.func_111125_b() - attackSpeedAttr.func_111126_e();
                    lastAttackThreshold = attackSpeed * 4.0;
                    lastAttackThreshold = Math.max(lastAttackThreshold, 8.0);
                }
                int lastAttackTime = player.field_70173_aa - player.func_142013_aG();
                if ((entityPunch || meleeProjectile) && (double)lastAttackTime >= lastAttackThreshold) {
                    Predicate<IAbility> hitAbilityCheck = a -> a instanceof IHitAbility && ((IHitAbility)((Object)a)).isActive(player);
                    float piercing = 0.0f;
                    for (IAbility ability : attackerAbilityProps.getEquippedAbilities(hitAbilityCheck)) {
                        Object punchSource = ((IHitAbility)((Object)ability)).getDamageSource(player, null);
                        if (!(punchSource instanceof ModDamageSource)) continue;
                        piercing += ((AbilityDamageSource)punchSource).getPierce();
                    }
                    piercing = MathHelper.func_76131_a((float)piercing, (float)0.0f, (float)1.0f);
                    boolean bonusApplied = false;
                    for (IAbility ability : attackerAbilityProps.getEquippedAbilities(hitAbilityCheck)) {
                        boolean canDamageLogias;
                        float damage = ((IHitAbility)((Object)ability)).hitEntity(player, entity);
                        ModDamageSource modDamageSource = ((IHitAbility)((Object)ability)).getDamageSource(player, null);
                        boolean isTargetLogia = DevilFruitCapability.get(entity).isLogia();
                        boolean isHardeningActive = HakiHelper.hasHardeningActive((LivingEntity)player);
                        boolean isDamageBypassingLogia = modDamageSource instanceof ModDamageSource && modDamageSource.isBypassingLogia();
                        boolean bl = canDamageLogias = !isTargetLogia || isTargetLogia && (isHardeningActive || isDamageBypassingLogia);
                        if (modDamageSource instanceof ModDamageSource) {
                            modDamageSource.setPiercing(piercing);
                        }
                        if (!canDamageLogias) continue;
                        if (damage < 0.0f) {
                            event.setCanceled(true);
                            break;
                        }
                        if (!(damage > 0.0f)) continue;
                        entity.field_70172_ad = 0;
                        entity.field_70737_aN = 0;
                        if (((IHitAbility)((Object)ability)).isStoppingAfterHit() && ability instanceof ContinuousAbility) {
                            ((ContinuousAbility)ability).stopContinuity(player);
                        }
                        if (!bonusApplied) {
                            damage = ((AbilityDamageSource)modDamageSource).getBonusDamage(damage) * (float)EntityStatsCapability.get((LivingEntity)player).getDamageMultiplier();
                            bonusApplied = true;
                        }
                        entity.func_70097_a((DamageSource)modDamageSource, damage);
                        event.setCanceled(true);
                    }
                }
            }
            for (IAbility ability : ablProps.getEquippedAndPassiveAbilities(core -> core.hasComponent(ModAbilityKeys.DAMAGE_TAKEN))) {
                try {
                    DamageTakenComponent damageTakenComponent = ability.getComponent(ModAbilityKeys.DAMAGE_TAKEN).get();
                    if (damageTakenComponent.getDamageState() != DamageTakenComponent.DamageState.HURT) continue;
                    float newDamage = damageTakenComponent.isDamageTaken(entity, damageSource, event.getAmount());
                    damageTakenComponent.setAmount(newDamage);
                    if (!(newDamage <= 0.0f)) continue;
                    event.setCanceled(true);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAttackEvent(WyLivingAttackEvent event) {
        DamageSource damageSource = event.getSource();
        LivingEntity sourceOwner = damageSource.func_76346_g() instanceof LivingEntity ? (LivingEntity)damageSource.func_76346_g() : null;
        LivingEntity entity = event.getEntityLiving();
        if (entity != null && !entity.field_70170_p.field_72995_K) {
            IEntityStats entityStatsProps = EntityStatsCapability.get(entity);
            if (entityStatsProps.getInvulnerableTime() > 0) {
                event.setCanceled(true);
                return;
            }
            IAbilityData ablProps = AbilityDataCapability.get(entity);
            if (ablProps == null) {
                return;
            }
            if (event.getSource() == ModDamageSource.DEVILS_CURSE) {
                return;
            }
            Object punchSource = null;
            if (sourceOwner instanceof PlayerEntity) {
                PlayerEntity playerOwner = (PlayerEntity)sourceOwner;
                Predicate<IAbility> hitAbilityCheck = a -> a instanceof IHitAbility && ((IHitAbility)((Object)a)).isActive(playerOwner);
                for (IAbility ability : AbilityDataCapability.get(sourceOwner).getEquippedAbilities(hitAbilityCheck)) {
                    punchSource = ((IHitAbility)((Object)ability)).getDamageSource(playerOwner, punchSource);
                }
            }
            if (entity instanceof PlayerEntity) {
                for (IAbility ability : ablProps.getEquippedAndPassiveAbilities()) {
                    boolean blockFallDamage;
                    boolean result;
                    if (ability instanceof IOnDamageTakenAbility && ability.canUse(entity).isSuccess() && !(result = ((IOnDamageTakenAbility)((Object)ability)).isDamageTaken(entity, (DamageSource)(punchSource == null ? damageSource : punchSource), event.getAmount()))) {
                        event.setCanceled(true);
                        break;
                    }
                    if (!(ability instanceof IFallDamageBlockingAbility) || damageSource != DamageSource.field_76379_h || !ability.canUse(entity).isSuccess() || !(blockFallDamage = !((IFallDamageBlockingAbility)((Object)ability)).hasFallDamage())) continue;
                    entity.field_70143_R = 0.0f;
                    ((IFallDamageBlockingAbility)((Object)ability)).resetFallDamage(entity);
                    event.setCanceled(true);
                    break;
                }
            }
            if (event.getSource().func_76346_g() instanceof PlayerEntity && (event.getSource().func_76355_l().equals("player") || event.getSource().func_76355_l().equals("mob")) && event.getAmount() > 0.0f) {
                PlayerEntity attacker = (PlayerEntity)event.getSource().func_76346_g();
                ablProps = AbilityDataCapability.get((LivingEntity)attacker);
                if (ablProps == null) {
                    return;
                }
                for (IAbility ability : ablProps.getEquippedAbilities()) {
                    if (ability == null) continue;
                    try {
                        IChangeDamageSourceAbility abl;
                        if (!(ability instanceof IChangeDamageSourceAbility) || !(abl = (IChangeDamageSourceAbility)((Object)ability)).isSourceChangeEnabled()) continue;
                        boolean sameGroup = ModEntityPredicates.getFriendlyFactions((LivingEntity)attacker).test((Entity)entity);
                        if (sameGroup) {
                            return;
                        }
                        double strength = attacker.func_110148_a(Attributes.field_233823_f_).func_111126_e();
                        if (strength == 0.0) {
                            return;
                        }
                        float damage = (float)((double)abl.damageToEntityWithSource(attacker, entity) * ((double)event.getAmount() / strength));
                        DamageSource source = abl.getSourceToUse(attacker);
                        boolean damaged = true;
                        if (entity.field_70172_ad == 0 || abl.cancelsOriginalDamage()) {
                            damaged = entity.func_70097_a(source, damage);
                            entity.field_70172_ad = 0;
                            entity.field_70737_aN = 0;
                        }
                        if (damaged && !abl.cancelsOriginalDamage()) continue;
                        event.setCanceled(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static boolean triggerDamageTakenAttackComponents(LivingEntity entity, DamageSource damageSource, float amount) {
        IAbilityData props = AbilityDataCapability.get(entity);
        for (IAbility ability : props.getEquippedAndPassiveAbilities(core -> core.hasComponent(ModAbilityKeys.DAMAGE_TAKEN))) {
            try {
                DamageTakenComponent damageTakenComponent;
                boolean isDisabled = ability.getComponent(ModAbilityKeys.DISABLE).map(comp -> comp.isDisabled()).orElse(false);
                boolean isPaused = ability.getComponent(ModAbilityKeys.PAUSE_TICK).map(comp -> comp.isPaused()).orElse(false);
                if (isDisabled || isPaused || (damageTakenComponent = ability.getComponent(ModAbilityKeys.DAMAGE_TAKEN).get()).getDamageState() != DamageTakenComponent.DamageState.ATTACK) continue;
                float newDamage = damageTakenComponent.isDamageTaken(entity, damageSource, amount);
                damageTakenComponent.setAmount(newDamage);
                if (!(newDamage <= 0.0f)) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntityAttackEvent(WyLivingDamageEvent event) {
        if (event.getEntityLiving() == null) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        if (abilityProps == null) {
            return;
        }
        for (IAbility ability : abilityProps.getEquippedAndPassiveAbilities(core -> core.hasComponent(ModAbilityKeys.DAMAGE_TAKEN))) {
            try {
                DamageTakenComponent damageTakenComponent = ability.getComponent(ModAbilityKeys.DAMAGE_TAKEN).get();
                if (damageTakenComponent.getDamageState() != DamageTakenComponent.DamageState.DAMAGE) continue;
                float newDamage = damageTakenComponent.isDamageTaken(entity, event.getSource(), event.getAmount());
                damageTakenComponent.setAmount(newDamage);
                event.setAmount(newDamage);
                if (!(newDamage <= 0.0f)) continue;
                event.setCanceled(true);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayarLogsOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        if (props == null) {
            return;
        }
        for (IAbility ability : props.getEquippedAbilities()) {
            if (ability != null) continue;
        }
    }

    @SubscribeEvent
    public static void onPotionEvent(PotionEvent.PotionApplicableEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        if (props == null) {
            return;
        }
        for (IAbility ability : props.getEquippedAndPassiveAbilities()) {
            try {
                if (!(ability instanceof PotionPassiveAbility)) continue;
                boolean applied = ((PotionPassiveAbility)ability).check(player, event.getPotionEffect());
                if (applied) {
                    event.setResult(Event.Result.ALLOW);
                    continue;
                }
                event.setResult(Event.Result.DENY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onEntityStoppedUsingBow(LivingEntityUseItemEvent.Stop event) {
        if (ItemsHelper.isBow(event.getItem())) {
            IAbilityData props = AbilityDataCapability.get(event.getEntityLiving());
            for (IAbility abl : props.getEquippedAbilities()) {
                Optional<BowTriggerComponent> opt = abl.getComponent(ModAbilityKeys.BOW_TRIGGER);
                if (!opt.isPresent() || !opt.get().tryShoot(event.getEntityLiving())) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onItemTossed(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (stack != null && !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74767_n("spawnedByAbility")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityClick(PlayerInteractEvent.EntityInteract event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (event.getHand() == Hand.OFF_HAND) {
            return;
        }
        if (event.getTarget() instanceof LivingEntity) {
            boolean flag;
            if (event.getTarget() instanceof PlayerEntity && (flag = CombatModeEvents.Common.tryLeashTarget(event.getPlayer(), (PlayerEntity)event.getTarget()))) {
                event.setCanceled(true);
                return;
            }
            flag = CombatModeEvents.Common.tryPickupTarget(event.getPlayer(), (LivingEntity)event.getTarget());
            if (flag) {
                event.setCanceled(true);
                return;
            }
        }
        if (event.getTarget() instanceof PlayerEntity) {
            AbilitiesEvents.startRidingZoan(event.getPlayer(), (PlayerEntity)event.getTarget());
        }
    }

    public static void startRidingZoan(PlayerEntity player, PlayerEntity mount) {
        boolean hasRideable;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)mount);
        if (abilityProps == null) {
            return;
        }
        boolean bl = hasRideable = abilityProps.getPassiveAbilities(RideableAbility.class::isInstance).stream().filter(abl -> abl.canUse((LivingEntity)mount).isSuccess()).count() > 0L;
        if (hasRideable) {
            player.func_184220_m((Entity)mount);
            ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SMountEntityPacket((Entity)player, (Entity)mount));
            ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SSetPassengersPacket((Entity)mount));
        }
    }

    @SubscribeEvent
    public static void onItemUsed(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntityLiving();
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        if (abilityProps == null) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack.func_222117_E()) {
            Food food = itemStack.func_77973_b().func_219967_s();
            int nutrition = food.func_221466_a();
            float saturationModifier = food.func_221469_b();
            for (IAbility abl : abilityProps.getEquippedAndPassiveAbilities()) {
                abl.getComponent(ModAbilityKeys.CONSUMPTION).ifPresent(component -> component.tryConsumption(entity, nutrition, saturationModifier));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onMouseClicked(InputEvent.ClickInputEvent event) {
        if (event.getHand() == Hand.MAIN_HAND) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
            if (abilityProps == null) {
                return;
            }
            if (event.shouldSwingHand() && event.isAttack() && !player.func_184838_M() && (double)player.func_184825_o(0.0f) >= 1.0) {
                for (IAbility abl : abilityProps.getEquippedAndPassiveAbilities()) {
                    abl.getComponent(ModAbilityKeys.SWING_TRIGGER).ifPresent(component -> WyNetwork.sendToServer(new CSwingTriggerPacket((LivingEntity)player, abl)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeavesWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)event.getPlayer());
            for (IAbility ability : props.getEquippedAbilities()) {
                AbilityHelper.emergencyStopAbility((LivingEntity)event.getPlayer(), ability);
            }
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)event.getEntity();
            IAbilityData props = AbilityDataCapability.get(entity);
            for (IAbility abl : props.getEquippedAbilities()) {
                AbilityHelper.emergencyStopAbility(entity, abl);
            }
            entity.func_195063_d((Effect)ModEffects.CHIYUPOPO.get());
        }
    }
}

