/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.abilities;

import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.ProjectileHitEvent;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class AbilityProtectionCommonEvents {
    @SubscribeEvent
    public static void restoreWorld(TickEvent.WorldTickEvent event) {
        if (event.world == null || event.phase == TickEvent.Phase.START || event.world.field_72995_K) {
            return;
        }
        event.world.func_217381_Z().func_76320_a("world restoration");
        ProtectedAreasData worldData = ProtectedAreasData.get(event.world);
        for (ProtectedArea area : worldData.getAllRestrictions().values()) {
            area.restoreBlocks(event.world);
        }
        event.world.func_217381_Z().func_76319_b();
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        if (!event.getWorld().field_72995_K) {
            ProtectedAreasData worldData = ProtectedAreasData.get(event.getWorld());
            Vector3d pos = event.getExplosion().getPosition();
            ProtectedArea area = worldData.getProtectedArea((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
            if (area != null) {
                if (!area.canDestroyBlocks()) {
                    event.getAffectedBlocks().clear();
                } else if (area.canRestoreBlocks()) {
                    Map<BlockPlacingHelper.DistanceBlockPos, ProtectedArea.RestorationEntry> map = event.getAffectedBlocks().stream().filter(p -> !event.getWorld().func_180495_p(p).func_196958_f() && area.isInside(p.func_177958_n(), p.func_177956_o(), p.func_177952_p())).map(p -> {
                        int hash = (p.func_177956_o() * 31 + p.func_177952_p()) * 31 + p.func_177958_n();
                        return new BlockPlacingHelper.DistanceBlockPos(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), hash);
                    }).distinct().collect(Collectors.toMap(p -> p, p -> new ProtectedArea.RestorationEntry(event.getWorld().func_82737_E(), BlockSnapshot.create((RegistryKey)event.getWorld().func_234923_W_(), (IWorld)event.getWorld(), (BlockPos)p, (int)2))));
                    area.queueForRestoration(map);
                }
                if (!area.canHurtEntities()) {
                    event.getAffectedEntities().clear();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAbilityHit(ProjectileHitEvent event) {
        if (event.getHit().func_216346_c() == RayTraceResult.Type.ENTITY) {
            boolean isWhitelisted = CommonConfig.INSTANCE.isAbilityProtectionWhitelisted(event.getProjectile().getParent());
            if (isWhitelisted) {
                return;
            }
            EntityRayTraceResult entityHit = (EntityRayTraceResult)event.getHit();
            if (entityHit.func_216348_a() instanceof LivingEntity) {
                LivingEntity hitEntity = (LivingEntity)entityHit.func_216348_a();
                ProtectedArea area = ProtectedAreasData.get(hitEntity.field_70170_p).getProtectedArea((int)hitEntity.func_226277_ct_(), (int)hitEntity.func_226278_cu_(), (int)hitEntity.func_226281_cx_());
                if (area != null && !area.canHurtEntities()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

