/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.effects.HandcuffedEffect;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class HandcuffsEvents {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a((Effect)ModEffects.HANDCUFFED.get())) {
            entity.func_199701_a_(new ItemStack((IItemProvider)ModItems.NORMAL_HANDCUFFS.get()));
        } else if (entity.func_70644_a((Effect)ModEffects.HANDCUFFED_KAIROSEKI.get())) {
            entity.func_199701_a_(new ItemStack((IItemProvider)ModItems.KAIROSEKI_HANDCUFFS.get()));
        } else if (entity.func_70644_a((Effect)ModEffects.HANDCUFFED_EXPLOSIVE.get()) && !entity.field_70170_p.field_72995_K) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 4.0f);
            explosion.setStaticDamage(15.0f);
            explosion.ignoreFactionChecks();
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(5));
            explosion.doExplosion();
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        LivingEntity target = event.getEntityLiving();
        if (target.func_70089_S() && target.func_70651_bq().stream().anyMatch(e -> e.func_188419_a() instanceof HandcuffedEffect) && target.field_70172_ad > 10) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!(event.getTarget() instanceof LivingEntity)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.func_184614_ca().func_77973_b() != ModItems.KEY.get()) {
            return;
        }
        LivingEntity target = (LivingEntity)event.getTarget();
        if (target.func_70651_bq().stream().anyMatch(e -> e.func_188419_a() instanceof HandcuffedEffect)) {
            ItemStack keyStack = player.func_184614_ca();
            keyStack.func_190918_g(1);
            if (target.func_70644_a((Effect)ModEffects.HANDCUFFED_EXPLOSIVE.get()) && !target.field_70170_p.field_72995_K) {
                ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)target, target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 4.0f);
                explosion.setStaticDamage(15.0f);
                explosion.ignoreFactionChecks();
                explosion.setSmokeParticles(new CommonExplosionParticleEffect(5));
                explosion.doExplosion();
            }
            target.func_195063_d((Effect)ModEffects.HANDCUFFED.get());
            target.func_195063_d((Effect)ModEffects.HANDCUFFED_KAIROSEKI.get());
            target.func_195063_d((Effect)ModEffects.HANDCUFFED_EXPLOSIVE.get());
        }
    }
}

