/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.events.ability.RenderMorphEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.items.weapons.ModSwordItem;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class HakiPassiveEvents {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity playerEntity;
        ItemStack heldItem;
        if (event.getEntityLiving() instanceof PlayerEntity && !(heldItem = (playerEntity = (PlayerEntity)event.getEntityLiving()).func_184614_ca()).func_190926_b() && heldItem.func_77984_f() && !(heldItem.func_77973_b() instanceof ModSwordItem)) {
            if (HakiHelper.hasImbuingActive((LivingEntity)playerEntity) && !heldItem.func_196082_o().func_74767_n("imbuingHakiActive")) {
                heldItem.func_196082_o().func_74757_a("imbuingHakiActive", true);
            } else if (heldItem.func_196082_o().func_74764_b("imbuingHakiActive") && !HakiHelper.hasImbuingActive((LivingEntity)playerEntity) && heldItem.func_196082_o().func_74767_n("imbuingHakiActive")) {
                heldItem.func_196082_o().func_82580_o("imbuingHakiActive");
            }
        }
    }

    @SubscribeEvent
    public static void onItemTossed(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (stack != null && !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74767_n("imbuingHakiActive")) {
            stack.func_196082_o().func_82580_o("imbuingHakiActive");
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.field_70170_p.field_72995_K || event.player.field_70173_aa % 20 != 0) {
            return;
        }
        PlayerEntity player = event.player;
        IAbilityData ablData = AbilityDataCapability.get((LivingEntity)player);
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        float maxOveruse = hakiProps.getMaxOveruse();
        float hakiOveruse = hakiProps.getHakiOveruse();
        if (maxOveruse <= 0.0f) {
            return;
        }
        if ((double)hakiOveruse >= (double)maxOveruse * 0.9) {
            player.func_195064_c(new EffectInstance((Effect)ModEffects.HAKI_OVERUSE.get(), 40, 0));
            if ((double)hakiOveruse >= (double)maxOveruse * 0.95) {
                player.func_195064_c(new EffectInstance((Effect)ModEffects.HAKI_OVERUSE.get(), 80, 1));
                if (hakiOveruse >= maxOveruse) {
                    player.func_195064_c(new EffectInstance((Effect)ModEffects.HAKI_OVERUSE.get(), 100, 2));
                }
            }
        }
        boolean hasAnyHaki = false;
        if (ablData == null) {
            return;
        }
        for (IAbility abl : ablData.getEquippedAbilities(AbilityCategory.HAKI.isAbilityPartofCategory().and(a -> !(a instanceof KenbunshokuHakiAuraAbility)))) {
            Optional<ContinuousComponent> comp;
            if (abl == null || !(comp = abl.getComponent(ModAbilityKeys.CONTINUOUS)).isPresent() || !comp.get().isContinuous()) continue;
            hasAnyHaki = true;
            break;
        }
        if (hasAnyHaki) {
            return;
        }
        int overuseHeal = (int)(-Math.max(5.0f, hakiProps.getTotalHakiExp() / 30.0f) * 6.0f);
        hakiProps.alterHakiOveruse(overuseHeal);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onZoanRendered(RenderMorphEvent.Pre event) {
        if (event.getEntity() == null) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a((Effect)ModEffects.UNCONSCIOUS.get()) && entity.func_70660_b((Effect)ModEffects.UNCONSCIOUS.get()).func_76459_b() <= 0) {
            entity.func_195063_d((Effect)ModEffects.UNCONSCIOUS.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onEntityRendered(RenderLivingEvent.Pre event) {
        if (event.getEntity() == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        LivingEntity entity = event.getEntity();
        if (AbilityHelper.isCarrying((LivingEntity)player, entity)) {
            boolean isFirstPerson;
            boolean bl = isFirstPerson = Minecraft.func_71410_x().field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON;
            if (isFirstPerson) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void mulPoseEntityModel(LivingEntity entity, MatrixStack matrixStack, float angle) {
        if (angle == 0.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 90.0f, true));
            entity.field_70759_as = 0.0f;
            entity.field_70758_at = 0.0f;
        } else if (angle == 1.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 45.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 90.0f, true));
            entity.field_70759_as = 45.0f;
            entity.field_70758_at = 45.0f;
        } else if (angle == 2.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 90.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229180_c_, 90.0f, true));
            entity.field_70759_as = 90.0f;
            entity.field_70758_at = 90.0f;
        } else if (angle == 3.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 45.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229178_a_, 90.0f, true));
            entity.field_70759_as = 90.0f;
            entity.field_70758_at = 90.0f;
        } else if (angle == 4.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229178_a_, 90.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
            entity.field_70759_as = 90.0f;
            entity.field_70758_at = 90.0f;
        } else if (angle == 5.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 45.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229182_e_, 90.0f, true));
            entity.field_70759_as = 90.0f;
            entity.field_70758_at = 90.0f;
        } else if (angle == 6.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229182_e_, 90.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 90.0f, true));
            entity.field_70759_as = 360.0f;
            entity.field_70758_at = 360.0f;
        } else if (angle == 7.0f) {
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229180_c_, 45.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229182_e_, 90.0f, true));
            entity.field_70759_as = 360.0f;
            entity.field_70758_at = 360.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFogRendered(EntityViewRenderEvent.FogDensity event) {
        boolean isActive;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        if (props == null) {
            return;
        }
        Ability ability = props.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        boolean bl = isActive = ability != null && ability.isContinuous();
        if (isActive && player.func_70644_a(Effects.field_76440_q)) {
            event.setCanceled(true);
            event.setDensity(1.0E-4f);
        }
    }
}

