/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.TradeEntry;
import xyz.pixelatedw.mineminenomi.api.entities.TraderEntity;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CChangeCombatBarPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CToggleCombatModePacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CUseAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.components.CChangeAbilityAltModePacket;
import xyz.pixelatedw.mineminenomi.packets.client.entity.CSwitchVehicleModePacket;
import xyz.pixelatedw.mineminenomi.packets.client.trade.CBuyFromTraderPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenPlayerScreenPacket;
import xyz.pixelatedw.mineminenomi.screens.ChallengesScreen;
import xyz.pixelatedw.mineminenomi.screens.CrewDetailsScreen;
import xyz.pixelatedw.mineminenomi.screens.PlayerStatsScreen;
import xyz.pixelatedw.mineminenomi.screens.QuestsTrackerScreen;
import xyz.pixelatedw.mineminenomi.screens.SelectHotbarAbilitiesScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
public class ModKeybindings {
    public static KeyBinding test;
    public static KeyBinding guiPlayer;
    public static KeyBinding enterCombatMode;
    public static KeyBinding nextCombatBar;
    public static KeyBinding prevCombatBar;
    public static KeyBinding changeAbilityMode;
    public static KeyBinding combatSlot1;
    public static KeyBinding combatSlot2;
    public static KeyBinding combatSlot3;
    public static KeyBinding combatSlot4;
    public static KeyBinding combatSlot5;
    public static KeyBinding combatSlot6;
    public static KeyBinding combatSlot7;
    public static KeyBinding combatSlot8;
    public static KeyBinding vehicleAltMode;
    public static ArrayList<KeyBinding> keyBindsCombatbar;
    private static final int[] PREVIOUS_INVENTORY_KEYBINDS;

    public static void init() {
        if (WyDebug.isDebug()) {
            test = new KeyBinding("Test Key", 80, ModI18n.CATEGORY_GENERAL);
            ClientRegistry.registerKeyBinding((KeyBinding)test);
        }
        vehicleAltMode = new KeyBinding(ModI18n.KEY_VEHICLE_ALT_MODE, 341, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)vehicleAltMode);
        guiPlayer = new KeyBinding(ModI18n.KEY_PLAYER, 82, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)guiPlayer);
        enterCombatMode = new KeyBinding(ModI18n.KEY_COMBATMODE, 342, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)enterCombatMode);
        nextCombatBar = new KeyBinding(ModI18n.KEY_NEXT_COMBAT_BAR, 93, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)nextCombatBar);
        prevCombatBar = new KeyBinding(ModI18n.KEY_PREV_COMBAT_BAR, 91, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)prevCombatBar);
        changeAbilityMode = new KeyBinding(ModI18n.KEY_CHANGE_ABILITY_MODE, 340, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)changeAbilityMode);
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT1, 49, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT2, 50, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT3, 51, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT4, 52, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT5, 53, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT6, 54, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT7, 55, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR1_COMBATSLOT8, 56, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT1, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT2, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT3, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT4, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT5, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT6, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT7, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR2_COMBATSLOT8, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT1, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT2, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT3, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT4, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT5, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT6, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT7, -1, ModI18n.CATEGORY_GENERAL));
        keyBindsCombatbar.add(new KeyBinding(ModI18n.KEY_BAR3_COMBATSLOT8, -1, ModI18n.CATEGORY_GENERAL));
        for (KeyBinding key : keyBindsCombatbar) {
            ClientRegistry.registerKeyBinding((KeyBinding)key);
        }
    }

    public static boolean isShiftKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
    }

    public static boolean isAltKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)342) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)346);
    }

    public static boolean isSpaceKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)32);
    }

    @SubscribeEvent
    public static void onPlayerJoins(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            for (int i = 0; i < PREVIOUS_INVENTORY_KEYBINDS.length; ++i) {
                ModKeybindings.PREVIOUS_INVENTORY_KEYBINDS[i] = -1;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaves(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        for (int i = 0; i < mc.field_71474_y.field_151456_ac.length; ++i) {
            KeyBinding kb = mc.field_71474_y.field_151456_ac[i];
            if (PREVIOUS_INVENTORY_KEYBINDS[i] == -1) continue;
            kb.func_197979_b(InputMappings.func_197954_a((int)PREVIOUS_INVENTORY_KEYBINDS[i], (int)0));
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null || event.getAction() == 0) {
            return;
        }
        InputMappings.Input input = InputMappings.Type.MOUSE.func_197944_a(event.getButton());
        ModKeybindings.checkKeybindings((PlayerEntity)player, input, event.getAction(), event.getButton(), 0);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null || event.getAction() == 0) {
            return;
        }
        InputMappings.Input input = InputMappings.func_197954_a((int)event.getKey(), (int)event.getScanCode());
        ModKeybindings.checkKeybindings((PlayerEntity)player, input, event.getAction(), event.getKey(), 1);
    }

    private static void checkKeybindings(PlayerEntity player, InputMappings.Input input, int action, int key, int type) {
        boolean isSecondaryScreenOpen;
        Screen screen;
        Minecraft mc = Minecraft.func_71410_x();
        if (vehicleAltMode.isActiveAndMatches(input)) {
            WyNetwork.sendToServer(new CSwitchVehicleModePacket());
        }
        boolean isPlayerScreen = (screen = mc.field_71462_r) != null && screen instanceof PlayerStatsScreen;
        boolean isAbilitiesScreen = screen != null && screen instanceof SelectHotbarAbilitiesScreen;
        boolean isCrewScreen = screen != null && screen instanceof CrewDetailsScreen;
        boolean isChallengesScreen = screen != null && screen instanceof ChallengesScreen;
        boolean isQuestScreen = screen != null && screen instanceof QuestsTrackerScreen;
        boolean bl = isSecondaryScreenOpen = isAbilitiesScreen || isCrewScreen || isChallengesScreen || isQuestScreen;
        if (action == 1 && (guiPlayer.isActiveAndMatches(input) && guiPlayer.func_151468_f() || (screen == null || isPlayerScreen || isSecondaryScreenOpen) && type == 1 && key == guiPlayer.getKey().func_197937_c())) {
            if (isPlayerScreen) {
                mc.func_147108_a(null);
            } else if (isSecondaryScreenOpen) {
                WyNetwork.sendToServer(new COpenPlayerScreenPacket());
            } else if (screen == null) {
                WyNetwork.sendToServer(new COpenPlayerScreenPacket());
            }
        }
        if (screen != null) {
            return;
        }
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        if (entityStatsProps.isInCombatMode() && action != 2) {
            int bars = ClientConfig.INSTANCE.getAbilityBarsOnScreen();
            int clientMaxBars = CommonConfig.INSTANCE.getAbilityBars();
            if (nextCombatBar.isActiveAndMatches(input) && nextCombatBar.func_151468_f()) {
                WyNetwork.sendToServer(new CChangeCombatBarPacket(0, bars, clientMaxBars));
            } else if (prevCombatBar.isActiveAndMatches(input) && prevCombatBar.func_151468_f()) {
                WyNetwork.sendToServer(new CChangeCombatBarPacket(1, bars, clientMaxBars));
            }
        }
        if (WyDebug.isDebug() && test.func_151470_d()) {
            List<TraderEntity> traders = WyHelper.getNearbyEntities(player.func_213303_ch(), (IWorld)player.field_70170_p, 5.0, ModEntityPredicates.canBeSeenBy((LivingEntity)player), TraderEntity.class);
            for (TraderEntity trader : traders) {
                List<TradeEntry> trades = trader.getTradingItems();
                for (TradeEntry trade : trades) {
                    WyNetwork.sendToServer(new CBuyFromTraderPacket(trader.func_145782_y(), trade.getItemStack(), -1));
                }
            }
        }
        if (enterCombatMode.isActiveAndMatches(input) && enterCombatMode.func_151468_f()) {
            ModKeybindings.keybindsAssignment(entityStatsProps);
        }
        for (int i = 0; i < keyBindsCombatbar.size(); ++i) {
            int bar = i / 8;
            if (!keyBindsCombatbar.get(i).isActiveAndMatches(input) || !keyBindsCombatbar.get(i).func_151468_f() || action == 2) continue;
            int k = i % 8 + (abilityDataProps.getCombatBarSet() + bar) * 8;
            Object abl = abilityDataProps.getEquippedAbility(k);
            boolean isOnCooldown = false;
            if (abl != null && abl.hasComponent(ModAbilityKeys.COOLDOWN)) {
                isOnCooldown = abl.getComponent(ModAbilityKeys.COOLDOWN).map(comp -> comp.isOnCooldown() && comp.getCooldown() > 10.0f).get();
            }
            if (entityStatsProps.isInCombatMode() && abl != null) {
                if (isOnCooldown) continue;
                if (changeAbilityMode.func_151470_d() && abl.hasComponent(ModAbilityKeys.ALT_MODE)) {
                    WyNetwork.sendToServer(new CChangeAbilityAltModePacket(k));
                    continue;
                }
                WyNetwork.sendToServer(new CUseAbilityPacket(k));
                continue;
            }
            player.field_71071_by.field_70461_c = i % 8;
        }
    }

    private static void keybindsAssignment(IEntityStats entityStatsProps) {
        Minecraft mc = Minecraft.func_71410_x();
        entityStatsProps.setCombatMode(!entityStatsProps.isInCombatMode());
        if (entityStatsProps.isInCombatMode()) {
            for (int i = 0; i < mc.field_71474_y.field_151456_ac.length; ++i) {
                KeyBinding kb = mc.field_71474_y.field_151456_ac[i];
                ModKeybindings.PREVIOUS_INVENTORY_KEYBINDS[i] = kb.getKey().func_197937_c();
                kb.func_197979_b(InputMappings.field_197958_a);
            }
            KeyBinding.func_74508_b();
        } else {
            for (int i = 0; i < mc.field_71474_y.field_151456_ac.length; ++i) {
                KeyBinding kb = mc.field_71474_y.field_151456_ac[i];
                if (PREVIOUS_INVENTORY_KEYBINDS[i] == -1) {
                    kb.func_197979_b(InputMappings.func_197954_a((int)kb.func_197977_i().func_197937_c(), (int)0));
                    continue;
                }
                kb.func_197979_b(InputMappings.func_197954_a((int)PREVIOUS_INVENTORY_KEYBINDS[i], (int)0));
            }
            KeyBinding.func_74508_b();
        }
        WyNetwork.sendToServer(new CToggleCombatModePacket(entityStatsProps.isInCombatMode()));
    }

    public static boolean isHotbarKeyConflicting(KeyBinding keybind) {
        for (KeyBinding kb : keyBindsCombatbar) {
            if (kb.equals(keybind) || !kb.getKey().equals((Object)keybind.getKey()) || !kb.getKeyModifier().equals((Object)keybind.getKeyModifier())) continue;
            return true;
        }
        return false;
    }

    static {
        keyBindsCombatbar = new ArrayList();
        PREVIOUS_INVENTORY_KEYBINDS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    }
}

