/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.pixelatedw.mineminenomi.world.features.structures.battleship.marine.MarineBattleshipPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.battleship.marine.MarineBattleshipStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.camp.bandit.BanditCampPieces;
import xyz.pixelatedw.mineminenomi.world.features.structures.camp.bandit.BanditCampStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.camp.marine.MarineCampPieces;
import xyz.pixelatedw.mineminenomi.world.features.structures.camp.marine.MarineCampStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.ghostship.GhostShipPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.ghostship.GhostShipStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.largebase.bandit.BanditLargeBasePiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.largebase.bandit.BanditLargeBaseStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.largebase.marine.MarineLargeBasePieces;
import xyz.pixelatedw.mineminenomi.world.features.structures.largebase.marine.MarineLargeBaseStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.largeship.pirate.PirateLargeShipPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.largeship.pirate.PirateLargeShipStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.mediumship.pirate.PirateMediumShipPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.mediumship.pirate.PirateMediumShipStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.skyisland.camp.SkyIslandCampPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.skyisland.camp.SkyIslandCampStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.skyisland.house.SkyIslandHousePiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.skyisland.house.SkyIslandHouseStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.skyisland.town.SkyIslandTownPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.skyisland.town.SkyIslandTownStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.bandit.BanditSmallBasePieces;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.bandit.BanditSmallBaseStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.marine.MarineSmallBasePiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.marine.MarineSmallBaseStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallship.pirate.PirateSmallShipPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallship.pirate.PirateSmallShipStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.blacklegkitchen.BlacklegKitchenPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.blacklegkitchen.BlacklegKitchenStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.brawlerring.BrawlerRingPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.brawlerring.BrawlerRingStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.medictent.MedicTentPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.medictent.MedicTentStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.sniperrange.SniperRangePiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.sniperrange.SniperRangeStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.swordsmandojo.SwordsmanDojoPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.training.swordsmandojo.SwordsmanDojoStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.watchtower.marine.MarineWatchTowerPiece;
import xyz.pixelatedw.mineminenomi.world.features.structures.watchtower.marine.MarineWatchTowerStructure;

public class ModStructures {
    private static final DeferredRegister<Structure<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"mineminenomi");
    public static final HashMap<Structure<?>, StructureFeature<?, ?>> REGISTERED_STRUCTURES = new HashMap();
    public static final RegistryObject<Structure<NoFeatureConfig>> PIRATE_SMALL_SHIP = REGISTRY.register("pirate_small_ship", PirateSmallShipStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> PIRATE_MEDIUM_SHIP = REGISTRY.register("pirate_medium_ship", PirateMediumShipStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> PIRATE_LARGE_SHIP = REGISTRY.register("pirate_large_ship", PirateLargeShipStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> MARINE_BATTLESHIP = REGISTRY.register("marine_battleship", MarineBattleshipStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> GHOST_SHIP = REGISTRY.register("ghost_ship", GhostShipStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> MARINE_SMALL_BASE = REGISTRY.register("marine_small_base", MarineSmallBaseStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> BANDIT_SMALL_BASE = REGISTRY.register("bandit_small_base", BanditSmallBaseStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> MARINE_LARGE_BASE = REGISTRY.register("marine_large_base", MarineLargeBaseStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> BANDIT_LARGE_BASE = REGISTRY.register("bandit_large_base", BanditLargeBaseStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> MARINE_CAMP = REGISTRY.register("marine_camp", MarineCampStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> BANDIT_CAMP = REGISTRY.register("bandit_camp", BanditCampStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> MARINE_WATCH_TOWER = REGISTRY.register("marine_watch_tower", MarineWatchTowerStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> SWORDSMAN_DOJO = REGISTRY.register("swordsman_dojo", SwordsmanDojoStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> BRAWLER_RING = REGISTRY.register("brawler_ring", BrawlerRingStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> BLACKLEG_KITCHEN = REGISTRY.register("blackleg_kitchen", BlacklegKitchenStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> MEDIC_TENT = REGISTRY.register("medic_tent", MedicTentStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> SNIPER_RANGE = REGISTRY.register("sniper_range", SniperRangeStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> SKY_ISLAND_CAMP = REGISTRY.register("sky_island_camp", SkyIslandCampStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> SKY_ISLAND_HOUSE = REGISTRY.register("sky_island_house", SkyIslandHouseStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> SKY_ISLAND_TOWN = REGISTRY.register("sky_island_town", SkyIslandTownStructure::new);

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand(((Structure)PIRATE_SMALL_SHIP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(8, 4, 54036900), false);
        ModStructures.setupMapSpacingAndLand(((Structure)PIRATE_MEDIUM_SHIP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(16, 4, 14036660), false);
        ModStructures.setupMapSpacingAndLand(((Structure)PIRATE_LARGE_SHIP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(16, 8, 991036900), false);
        ModStructures.setupMapSpacingAndLand(((Structure)MARINE_BATTLESHIP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(20, 16, 995474911), false);
        ModStructures.setupMapSpacingAndLand(((Structure)GHOST_SHIP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(16, 8, 115474911), false);
        ModStructures.setupMapSpacingAndLand(((Structure)MARINE_SMALL_BASE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(25, 16, 150718788), true);
        ModStructures.setupMapSpacingAndLand(((Structure)BANDIT_SMALL_BASE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(20, 10, 908718788), false);
        ModStructures.setupMapSpacingAndLand(((Structure)MARINE_LARGE_BASE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(25, 16, 450718615), false);
        ModStructures.setupMapSpacingAndLand(((Structure)BANDIT_LARGE_BASE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(25, 16, 1207542615), false);
        ModStructures.setupMapSpacingAndLand(((Structure)MARINE_CAMP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(16, 8, 258711788), true);
        ModStructures.setupMapSpacingAndLand(((Structure)BANDIT_CAMP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(16, 8, 358711788), true);
        ModStructures.setupMapSpacingAndLand(((Structure)MARINE_WATCH_TOWER.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(16, 10, 810715715), true);
        ModStructures.setupMapSpacingAndLand(((Structure)SWORDSMAN_DOJO.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(32, 16, 165132894), true);
        ModStructures.setupMapSpacingAndLand(((Structure)BRAWLER_RING.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(32, 16, 265132894), true);
        ModStructures.setupMapSpacingAndLand(((Structure)BLACKLEG_KITCHEN.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(32, 16, 315132894), true);
        ModStructures.setupMapSpacingAndLand(((Structure)MEDIC_TENT.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(32, 16, 465152894), true);
        ModStructures.setupMapSpacingAndLand(((Structure)SNIPER_RANGE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(32, 16, 111132894), true);
        ModStructures.setupMapSpacingAndLand(((Structure)SKY_ISLAND_CAMP.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(40, 30, 235132894), false);
        ModStructures.setupMapSpacingAndLand(((Structure)SKY_ISLAND_HOUSE.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(40, 30, 335123894), false);
        ModStructures.setupMapSpacingAndLand(((Structure)SKY_ISLAND_TOWN.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), new StructureSeparationSettings(80, 50, 435132894), false);
        Pieces.registerAllPieces();
    }

    public static <F extends Structure<?>, S extends StructureFeature<?, ?>> void setupMapSpacingAndLand(S configuredStructure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure structure = configuredStructure.field_236268_b_;
        REGISTERED_STRUCTURES.put(structure, configuredStructure);
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), (Object)structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add((Object)structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put((Object)structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
        Registry registry = WorldGenRegistries.field_243654_f;
        Registry.func_218322_a((Registry)registry, (ResourceLocation)structure.getRegistryName(), configuredStructure);
        FlatGenerationSettings.field_202247_j.put(structure, configuredStructure);
    }

    public static void register(IEventBus eventBus) {
        REGISTRY.register(eventBus);
    }

    public static class Pieces {
        public static final IStructurePieceType PIRATE_SMALL_SHIP_PIECE = PirateSmallShipPiece::new;
        public static final IStructurePieceType PIRATE_MEDIUM_SHIP_PIECE = PirateMediumShipPiece::new;
        public static final IStructurePieceType PIRATE_LARGE_SHIP_PIECE = PirateLargeShipPiece::new;
        public static final IStructurePieceType MARINE_BATTLESHIP_PIECE = MarineBattleshipPiece::new;
        public static final IStructurePieceType GHOST_SHIP_PIECE = GhostShipPiece::new;
        public static final IStructurePieceType MARINE_SMALL_BASE_PIECE = MarineSmallBasePiece::new;
        public static final IStructurePieceType BANDIT_SMALL_BASE_HOUSE_PIECE = BanditSmallBasePieces.HousePiece::new;
        public static final IStructurePieceType BANDIT_SMALL_BASE_UNDERGROUND_PIECE = BanditSmallBasePieces.UndergroundPiece::new;
        public static final IStructurePieceType MARINE_LARGE_BASE_BODY_PIECE = MarineLargeBasePieces.MainBodyPiece::new;
        public static final IStructurePieceType MARINE_LARGE_BASE_PRISON_PIECE = MarineLargeBasePieces.PrisonPiece::new;
        public static final IStructurePieceType BANDIT_LARGE_BASE_PIECE = BanditLargeBasePiece::new;
        public static final IStructurePieceType MARINE_CAMP_PIECE = MarineCampPieces.Piece::new;
        public static final IStructurePieceType BANDIT_CAMP_PIECE = BanditCampPieces.Piece::new;
        public static final IStructurePieceType MARINE_WATCH_TOWER_PIECE = MarineWatchTowerPiece::new;
        public static final IStructurePieceType SWORDSMAN_DOJO_PIECE = SwordsmanDojoPiece::new;
        public static final IStructurePieceType BRAWLER_RING_PIECE = BrawlerRingPiece::new;
        public static final IStructurePieceType BLACKLEG_KITCHEN_PIECE = BlacklegKitchenPiece::new;
        public static final IStructurePieceType MEDIC_TENT_PIECE = MedicTentPiece::new;
        public static final IStructurePieceType SNIPER_RANGE_PIECE = SniperRangePiece::new;
        public static final IStructurePieceType SKY_ISLAND_CAMP_PIECE = SkyIslandCampPiece::new;
        public static final IStructurePieceType SKY_ISLAND_HOUSE_PIECE = SkyIslandHousePiece::new;
        public static final IStructurePieceType SKY_ISLAND_TOWN_PIECE = SkyIslandTownPiece::new;

        public static void registerAllPieces() {
            Pieces.registerStructurePiece(PIRATE_SMALL_SHIP_PIECE, new ResourceLocation("mineminenomi", "pirate_small_ship_piece"));
            Pieces.registerStructurePiece(PIRATE_MEDIUM_SHIP_PIECE, new ResourceLocation("mineminenomi", "pirate_medium_ship_piece"));
            Pieces.registerStructurePiece(PIRATE_LARGE_SHIP_PIECE, new ResourceLocation("mineminenomi", "pirate_large_ship_piece"));
            Pieces.registerStructurePiece(MARINE_BATTLESHIP_PIECE, new ResourceLocation("mineminenomi", "marine_battleship_piece"));
            Pieces.registerStructurePiece(GHOST_SHIP_PIECE, new ResourceLocation("mineminenomi", "ghost_ship_piece"));
            Pieces.registerStructurePiece(MARINE_LARGE_BASE_BODY_PIECE, new ResourceLocation("mineminenomi", "marine_large_base_body_piece"));
            Pieces.registerStructurePiece(MARINE_LARGE_BASE_PRISON_PIECE, new ResourceLocation("mineminenomi", "marine_large_base_prison_piece"));
            Pieces.registerStructurePiece(MARINE_SMALL_BASE_PIECE, new ResourceLocation("mineminenomi", "marine_small_base_piece"));
            Pieces.registerStructurePiece(BANDIT_SMALL_BASE_HOUSE_PIECE, new ResourceLocation("mineminenomi", "bandit_small_base_house_piece"));
            Pieces.registerStructurePiece(BANDIT_SMALL_BASE_UNDERGROUND_PIECE, new ResourceLocation("mineminenomi", "bandit_small_base_underground_piece"));
            Pieces.registerStructurePiece(BANDIT_LARGE_BASE_PIECE, new ResourceLocation("mineminenomi", "bandit_small_base_piece"));
            Pieces.registerStructurePiece(MARINE_CAMP_PIECE, new ResourceLocation("mineminenomi", "marine_camp_piece"));
            Pieces.registerStructurePiece(BANDIT_CAMP_PIECE, new ResourceLocation("mineminenomi", "bandit_camp_piece"));
            Pieces.registerStructurePiece(MARINE_WATCH_TOWER_PIECE, new ResourceLocation("mineminenomi", "marine_watch_tower_piece"));
            Pieces.registerStructurePiece(SWORDSMAN_DOJO_PIECE, new ResourceLocation("mineminenomi", "swordsman_dojo_piece"));
            Pieces.registerStructurePiece(BRAWLER_RING_PIECE, new ResourceLocation("mineminenomi", "brawler_ring_piece"));
            Pieces.registerStructurePiece(BLACKLEG_KITCHEN_PIECE, new ResourceLocation("mineminenomi", "black_leg_kitchen_piece"));
            Pieces.registerStructurePiece(MEDIC_TENT_PIECE, new ResourceLocation("mineminenomi", "medic_tent_piece"));
            Pieces.registerStructurePiece(SNIPER_RANGE_PIECE, new ResourceLocation("mineminenomi", "sniper_range_piece"));
            Pieces.registerStructurePiece(SKY_ISLAND_CAMP_PIECE, new ResourceLocation("mineminenomi", "sky_island_camp_piece"));
            Pieces.registerStructurePiece(SKY_ISLAND_HOUSE_PIECE, new ResourceLocation("mineminenomi", "sky_island_house_piece"));
            Pieces.registerStructurePiece(SKY_ISLAND_TOWN_PIECE, new ResourceLocation("mineminenomi", "sky_island_town_piece"));
        }

        static void registerStructurePiece(IStructurePieceType structurePiece, ResourceLocation res) {
            Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)res, (Object)structurePiece);
        }
    }
}

