/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.integrations.clothconfig;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.ColorEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.LongListEntry;
import me.shedaniel.clothconfig2.forge.gui.entries.StringListListEntry;
import me.shedaniel.clothconfig2.forge.impl.builders.DropdownMenuBuilder;
import me.shedaniel.clothconfig2.forge.impl.builders.SubCategoryBuilder;
import me.shedaniel.math.Color;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.abilities.mera.HikenAbility;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.config.ChallengesConfig;
import xyz.pixelatedw.mineminenomi.config.FactionsConfig;
import xyz.pixelatedw.mineminenomi.config.GeneralConfig;
import xyz.pixelatedw.mineminenomi.config.SystemConfig;
import xyz.pixelatedw.mineminenomi.config.UIConfig;
import xyz.pixelatedw.mineminenomi.config.WorldEventsConfig;
import xyz.pixelatedw.mineminenomi.config.WorldFeaturesConfig;
import xyz.pixelatedw.mineminenomi.config.options.BooleanOption;
import xyz.pixelatedw.mineminenomi.config.options.ColorOption;
import xyz.pixelatedw.mineminenomi.config.options.DoubleOption;
import xyz.pixelatedw.mineminenomi.config.options.EnumOption;
import xyz.pixelatedw.mineminenomi.config.options.IntegerOption;
import xyz.pixelatedw.mineminenomi.config.options.LongOption;
import xyz.pixelatedw.mineminenomi.config.options.StringListOption;
import xyz.pixelatedw.mineminenomi.init.ModI18nConfig;
import xyz.pixelatedw.mineminenomi.integrations.clothconfig.AbilityDropdownEntry;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ClothConfigIntegration {
    public static void registerModConfig() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (client, parent) -> {
            ConfigBuilder builder = ConfigBuilder.create();
            int i = 1 + new Random().nextInt(3);
            builder.setTitle((ITextComponent)new TranslationTextComponent(ModI18nConfig.CONFIG_TITLE)).setDefaultBackgroundTexture(new ResourceLocation("mineminenomi:textures/blocks/poneglyph" + i + ".png"));
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            ConfigCategory general = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.GENERAL_CATEGORY));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.EXTRA_HEARTS));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, GeneralConfig.HEALTH_GAIN_FREQUENCY));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.RACE_RANDOMIZER));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.ALLOW_MINK_RACE_SELECT));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.PUBLIC_REMOVEDF));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.PUBLIC_CHECK_FRUITS));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntField(entryBuilder, GeneralConfig.DORIKI_LIMIT));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntField(entryBuilder, GeneralConfig.HAKI_EXP_LIMIT));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.DESTROY_SPAWNER));
            general.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.DESTROY_WATER));
            SubCategoryBuilder npcs = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.NPCS_CATEGORY)).setExpanded(false);
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.MOB_REWARDS));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.MINIMUM_DORIKI_PER_KILL));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addDoubleField(entryBuilder, GeneralConfig.DORIKI_REWARD_MULTIPLIER));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addDoubleField(entryBuilder, GeneralConfig.BELLY_REWARD_MULTIPLIER));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addDoubleField(entryBuilder, GeneralConfig.BOUNTY_REWARD_MULTIPLIER));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addDoubleField(entryBuilder, GeneralConfig.HAKI_EXP_MULTIPLIER));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addDoubleField(entryBuilder, GeneralConfig.LOYALTY_MULTIPLIER));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.DESPAWN_WITH_NAMETAG));
            npcs.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.NATIVE_HAKI));
            general.addEntry((AbstractConfigListEntry)npcs.build());
            SubCategoryBuilder keepStats = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Keep Stats")).setTooltip(new ITextComponent[]{new TranslationTextComponent(ModI18nConfig.KEEP_STATS_SUB_CATEGORY_TOOLTIP)}).setExpanded(false);
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.RACE_KEEP));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.FACTION_KEEP));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.FIGHTING_STYLE_KEEP));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.DEVIL_FRUIT_KEEP));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, GeneralConfig.DORIKI_KEEP_PERCENTAGE));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, GeneralConfig.BOUNTY_KEEP_PERCENTAGE));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, GeneralConfig.BELLY_KEEP_PERCENTAGE));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, GeneralConfig.HAKI_EXP_KEEP_PERCENTAGE));
            keepStats.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, GeneralConfig.LOYALTY_KEEP_PERCENTAGE));
            general.addEntry((AbstractConfigListEntry)keepStats.build());
            SubCategoryBuilder quests = entryBuilder.startSubCategory((ITextComponent)new StringTextComponent("Quests & Trials")).setExpanded(false);
            quests.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.ENABLE_TRIALS));
            quests.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, GeneralConfig.ENABLE_STYLES_PROGRESSION));
            general.addEntry((AbstractConfigListEntry)quests.build());
            ConfigCategory abilities = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.ABILITIES_CATEGORY));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.ABILITY_GRIEFING));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.ABILITY_FRAUD_CHECKS));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, AbilitiesConfig.ABILITY_BARS));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.YAMI_POWER));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.ENABLE_AWAKENINGS));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.WATER_CHECKS));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.SHARED_COOLDOWNS));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.REMOVE_Y_RESTRICTION));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.RANDOMIZED_FRUITS));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.COMBAT_STATE_UPDATE_CHAT_MESSAGGE));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addDoubleField(entryBuilder, AbilitiesConfig.DEVIL_FRUIT_DROP_FROM_LEAVES));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.LOGIA_INVULNERABILITY));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.LOGIA_RETURN_EFFECT));
            abilities.addEntry(ClothConfigIntegration.addEnumSelector(entryBuilder, AbilitiesConfig.LOGIA_PROJECTILE_HIT_LOGIC));
            abilities.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addStringList(entryBuilder, AbilitiesConfig.BANNED_ABILITIES));
            SubCategoryBuilder haki = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.HAKI_CATEGORY)).setExpanded(true);
            haki.add(ClothConfigIntegration.addEnumSelector(entryBuilder, AbilitiesConfig.HAOSHOKU_HAKI_UNLOCK_LOGIC));
            haki.add(ClothConfigIntegration.addEnumSelector(entryBuilder, AbilitiesConfig.HAOSHOKU_HAKI_COLORING_LOGIC));
            haki.add((AbstractConfigListEntry)ClothConfigIntegration.addColorField(entryBuilder, AbilitiesConfig.HAKI_COLOR));
            abilities.addEntry((AbstractConfigListEntry)haki.build());
            SubCategoryBuilder onefruit = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.ONE_FRUIT_CATEGORY)).setExpanded(false);
            onefruit.add(ClothConfigIntegration.addEnumSelector(entryBuilder, AbilitiesConfig.ONE_FRUIT_PER_WORLD));
            onefruit.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, AbilitiesConfig.UNABLE_TO_PICKUP_DF));
            onefruit.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, AbilitiesConfig.FRUITS_LIMIT_INVENTORY));
            onefruit.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, AbilitiesConfig.DAYS_FOR_INACTIVITY));
            abilities.addEntry((AbstractConfigListEntry)onefruit.build());
            SubCategoryBuilder ablprot = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.ABL_PROTECTION_CATEGORY)).setExpanded(false);
            ablprot.add((AbstractConfigListEntry)ClothConfigIntegration.addStringList(entryBuilder, AbilitiesConfig.GLOBAL_PROTECTION_WHITELIST));
            ablprot.add((AbstractConfigListEntry)ClothConfigIntegration.addLongField(entryBuilder, AbilitiesConfig.GLOBAL_PROTECTION_RESTORATION_GRACE));
            abilities.addEntry((AbstractConfigListEntry)ablprot.build());
            SubCategoryBuilder dfrespawns = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.DF_RESPAWNS_CATEGORY)).setExpanded(false);
            dfrespawns.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, AbilitiesConfig.DROPPED_APPLES_RESPAWN_CHANCE));
            dfrespawns.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, AbilitiesConfig.ENTITY_INVENTORY_APPLES_RESPAWN_CHANCE));
            dfrespawns.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, AbilitiesConfig.CHESTS_APPLES_RESPAWN_CHANCE));
            abilities.addEntry((AbstractConfigListEntry)dfrespawns.build());
            ConfigCategory factions = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.FACTION_CATEGORY));
            factions.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, FactionsConfig.DISABLE_FRIENDLY_FIRE));
            SubCategoryBuilder bounty = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.BOUNTY_SUB_CATEGORY)).setExpanded(false);
            bounty.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, FactionsConfig.TIME_BETWEEN_PACKAGE_DROPS));
            factions.addEntry((AbstractConfigListEntry)bounty.build());
            SubCategoryBuilder crew = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.CREW_SUB_CATEGORY)).setExpanded(false);
            crew.add((AbstractConfigListEntry)ClothConfigIntegration.addIntField(entryBuilder, FactionsConfig.CREW_BOUNTY_REQUIREMENT));
            crew.add((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, FactionsConfig.WORLD_MESSAGE_ON_CREW_CREATE));
            factions.addEntry((AbstractConfigListEntry)crew.build());
            ConfigCategory challenges = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.CHALLENGES_CATEGORY));
            challenges.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, ChallengesConfig.ENABLE_CHALLENGES));
            challenges.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, ChallengesConfig.CHALLENGE_CACHING));
            challenges.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, ChallengesConfig.RETURN_TO_SAFETY));
            ConfigCategory worldEvents = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.WORLD_EVENTS_CATEGORY));
            worldEvents.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, WorldEventsConfig.SPAWN_WORLD_HUMANOIDS));
            worldEvents.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, WorldEventsConfig.SPAWN_WORLD_ANIMALS));
            SubCategoryBuilder traders = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.TRADERS_SUB_CATEGORY)).setExpanded(false);
            traders.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldEventsConfig.TIME_BETWEEN_TRADER_SPAWNS));
            traders.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldEventsConfig.SPAWN_CHANCE_TRADER));
            worldEvents.addEntry((AbstractConfigListEntry)traders.build());
            SubCategoryBuilder trainers = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.TRAINERS_SUB_CATEGORY)).setExpanded(false);
            trainers.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldEventsConfig.TIME_BETWEEN_TRAINER_SPAWNS));
            trainers.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldEventsConfig.SPAWN_CHANCE_TRAINER));
            worldEvents.addEntry((AbstractConfigListEntry)trainers.build());
            SubCategoryBuilder ambushes = entryBuilder.startSubCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.AMBUSHES_SUB_CATEGORY)).setExpanded(false);
            ambushes.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldEventsConfig.TIME_BETWEEN_AMBUSH_SPAWNS));
            ambushes.add((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldEventsConfig.SPAWN_CHANCE_AMBUSH));
            worldEvents.addEntry((AbstractConfigListEntry)ambushes.build());
            ConfigCategory worldFeatures = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.STRUCTURES_CATEGORY));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_TRAINING_STRUCTURES));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_SKY_ISLANDS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_GHOST_SHIPS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_SMALL_SHIPS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_MEDIUM_SHIPS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_LARGE_SHIPS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_CAMPS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_SMALL_BASES));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_LARGE_BASES));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_WATCH_TOWERS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.SPAWN_CHANCE_PONEGLYPHS));
            worldFeatures.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, WorldFeaturesConfig.KAIROSEKI_SPAWN_COUNT));
            ConfigCategory ui = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.UI_CATEGORY));
            ui.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addIntSlider(entryBuilder, UIConfig.ABILITY_BARS_ON_SCREEN));
            ui.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, UIConfig.SHOW_KEYBIND));
            ui.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, UIConfig.MERGE_ABILITY_BONUSES));
            ui.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, UIConfig.HIDE_ABILITY_STATS));
            ui.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, UIConfig.SIMPLE_DISPLAYS));
            ui.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, UIConfig.USE_HEARTS_BAR));
            ui.addEntry(ClothConfigIntegration.addEnumSelector(entryBuilder, UIConfig.SLOT_NUMBER_DISPLAY));
            ConfigCategory system = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent(ModI18nConfig.SYSTEM_CATEGORY));
            system.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, SystemConfig.MASTER_COMMAND));
            system.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, SystemConfig.UPDATE_MESSAGE));
            system.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, SystemConfig.MOD_SPLASH_TEXT));
            system.addEntry((AbstractConfigListEntry)ClothConfigIntegration.addBooleanToggle(entryBuilder, SystemConfig.BLUE_GORO));
            builder.setParentScreen(parent);
            return builder.build();
        });
    }

    private static ColorEntry addColorField(ConfigEntryBuilder entryBuilder, ColorOption option) {
        int color = WyHelper.hexToRGB((String)option.getValue().get()).getRGB();
        return entryBuilder.startColorField(option.getTitleComponent(), Color.ofOpaque((int)color)).setDefaultValue(0xFF0000).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.saveColor(Color.ofOpaque((int)o))).build();
    }

    private static StringListListEntry addStringList(ConfigEntryBuilder entryBuilder, StringListOption option) {
        return entryBuilder.startStrList(option.getTitleComponent(), (List)option.getValue().get()).setDefaultValue((List)option.getDefault()).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.getValue().set(o)).build();
    }

    private static DropdownBoxEntry addItemDropdown(ConfigEntryBuilder entryBuilder) {
        DropdownBoxEntry.SelectionTopCellElement topCell = DropdownMenuBuilder.TopCellElementBuilder.ofItemObject((Item)Items.field_151034_e);
        return entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("Title"), topCell, DropdownMenuBuilder.CellCreatorBuilder.ofItemObject()).setDefaultValue(null).setSelections((Iterable)ForgeRegistries.ITEMS.getValues().stream().sorted(Comparator.comparing(Item::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build();
    }

    private static DropdownBoxEntry addAbilityDropdown(ConfigEntryBuilder entryBuilder) {
        DropdownBoxEntry.SelectionTopCellElement<AbilityCore> topCell = AbilityDropdownEntry.ofAbilityObject(HikenAbility.INSTANCE);
        return entryBuilder.startDropdownMenu((ITextComponent)new StringTextComponent("Title"), topCell, AbilityDropdownEntry.ofAbilityObject()).setDefaultValue(null).setSelections((Iterable)ModRegistries.ABILITIES.getValues().stream().sorted(Comparator.comparing(AbilityCore::toString)).collect(Collectors.toCollection(LinkedHashSet::new))).setSaveConsumer(item -> System.out.println("save this " + item)).build();
    }

    private static <T extends Enum<T>> EnumListEntry<T> addEnumSelector(ConfigEntryBuilder entryBuilder, EnumOption<T> option) {
        return entryBuilder.startEnumSelector(option.getTitleComponent(), option.getEnumClass(), (Enum)option.getValue().get()).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.getValue().set(o)).setDefaultValue((Enum)option.getDefault()).build();
    }

    private static BooleanListEntry addBooleanToggle(ConfigEntryBuilder entryBuilder, BooleanOption option) {
        return entryBuilder.startBooleanToggle(option.getTitleComponent(), ((Boolean)option.getValue().get()).booleanValue()).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.getValue().set(o)).setDefaultValue(((Boolean)option.getDefault()).booleanValue()).build();
    }

    private static DoubleListEntry addDoubleField(ConfigEntryBuilder entryBuilder, DoubleOption option) {
        return entryBuilder.startDoubleField(option.getTitleComponent(), ((Double)option.getValue().get()).doubleValue()).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.getValue().set(o)).setMin(((Double)option.getMin()).doubleValue()).setMax(((Double)option.getMax()).doubleValue()).setDefaultValue(((Double)option.getDefault()).doubleValue()).build();
    }

    private static IntegerListEntry addIntField(ConfigEntryBuilder entryBuilder, IntegerOption option) {
        return entryBuilder.startIntField(option.getTitleComponent(), ((Integer)option.getValue().get()).intValue()).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.getValue().set(o)).setMin(((Integer)option.getMin()).intValue()).setMax(((Integer)option.getMax()).intValue()).setDefaultValue(((Integer)option.getDefault()).intValue()).build();
    }

    private static IntegerSliderEntry addIntSlider(ConfigEntryBuilder entryBuilder, IntegerOption option) {
        return entryBuilder.startIntSlider(option.getTitleComponent(), ((Integer)option.getValue().get()).intValue(), ((Integer)option.getMin()).intValue(), ((Integer)option.getMax()).intValue()).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.getValue().set(o)).setMin(((Integer)option.getMin()).intValue()).setMax(((Integer)option.getMax()).intValue()).setDefaultValue(((Integer)option.getDefault()).intValue()).build();
    }

    private static LongListEntry addLongField(ConfigEntryBuilder entryBuilder, LongOption option) {
        return entryBuilder.startLongField(option.getTitleComponent(), ((Long)option.getValue().get()).longValue()).setTooltip(new ITextComponent[]{option.getDescriptionComponent()}).setSaveConsumer(o -> option.getValue().set(o)).setMin(((Long)option.getMin()).longValue()).setMax(((Long)option.getMax()).longValue()).setDefaultValue(((Long)option.getDefault()).longValue()).build();
    }
}

