/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GoldDenDenMushiItem
extends Item {
    public GoldDenDenMushiItem() {
        super(new Item.Properties().func_200916_a(ModCreativeTabs.MISC).func_200917_a(1));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("inUse") || world.field_72995_K) {
            return;
        }
        CompoundNBT nbt = stack.func_77978_p();
        nbt.func_74768_a("countdown", nbt.func_74762_e("countdown") - 1);
        int t = Math.max((stack.func_196082_o().func_74762_e("countdown") - 180) / 20, 0);
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_146105_b((ITextComponent)new StringTextComponent("\u00a76Countdown: " + t + " seconds\u00a7r"), true);
        }
        int[] pos = nbt.func_74759_k("coords");
        if (nbt.func_74762_e("countdown") > 40 && nbt.func_74762_e("countdown") < 180 && nbt.func_74762_e("countdown") % 5 == 0) {
            for (int i = 0; i < 20; ++i) {
                CannonBallProjectile projectile = new CannonBallProjectile(world, (LivingEntity)entity);
                projectile.func_70107_b((double)pos[0] + WyHelper.randomWithRange(-50, 50), pos[1] + 100, (double)pos[2] + WyHelper.randomWithRange(-50, 50));
                projectile.setDamage(50.0f);
                projectile.setMaxLife(60);
                world.func_217376_c((Entity)projectile);
                projectile.func_234612_a_(entity, 90.0f, 0.0f, 0.0f, 3.0f, 0.0f);
            }
        }
        if (nbt.func_74762_e("countdown") == 0) {
            BlockPos spawnPos;
            int i;
            stack.func_190918_g(1);
            EntityType captainEntity = (EntityType)ModEntities.MARINE_CAPTAIN.get();
            EntityType gruntEntity = (EntityType)ModEntities.MARINE_GRUNT.get();
            EntityType pacifistaEntity = (EntityType)ModEntities.PACIFISTA.get();
            int nrPacifistas = (int)WyHelper.randomWithRange(1, 5);
            int nrCaptains = (int)WyHelper.randomWithRange(10, 20);
            int nrGrunts = (int)WyHelper.randomWithRange(100, 200);
            for (i = 0; i < nrPacifistas; ++i) {
                spawnPos = WyHelper.findOnGroundSpawnLocation(world, captainEntity, new BlockPos(pos[0], pos[1], pos[2]), 50);
                if (spawnPos == null) continue;
                pacifistaEntity.func_220342_a((ServerWorld)world, null, null, null, spawnPos, SpawnReason.EVENT, false, false);
            }
            for (i = 0; i < nrCaptains; ++i) {
                spawnPos = WyHelper.findOnGroundSpawnLocation(world, captainEntity, new BlockPos(pos[0], pos[1], pos[2]), 50);
                if (spawnPos == null) continue;
                captainEntity.func_220342_a((ServerWorld)world, null, null, null, spawnPos, SpawnReason.EVENT, false, false);
            }
            for (i = 0; i < nrGrunts; ++i) {
                spawnPos = WyHelper.findOnGroundSpawnLocation(world, gruntEntity, new BlockPos(pos[0], pos[1], pos[2]), 50);
                if (spawnPos == null) continue;
                gruntEntity.func_220342_a((ServerWorld)world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (!player.func_184586_b(hand).func_196082_o().func_74767_n("inUse") && !world.field_72995_K) {
            if (WyHelper.isInChallengeDimension(world)) {
                return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
            }
            CompoundNBT compoundNBT = player.func_184586_b(hand).func_196082_o();
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            if (!props.hasMarineRank(FactionHelper.MarineRank.ADMIRAL)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_BUSTER_CALL_REQUIREMENT), Util.field_240973_b_);
                return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
            }
            compoundNBT.func_74768_a("countdown", 1000);
            compoundNBT.func_74757_a("inUse", true);
            compoundNBT.func_74783_a("coords", new int[]{player.func_233580_cy_().func_177958_n(), player.func_233580_cy_().func_177956_o(), player.func_233580_cy_().func_177952_p()});
            world.func_217369_A().stream().filter(target -> EntityStatsCapability.get((LivingEntity)target).isMarine()).forEach(target -> target.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_BUSTER_CALL_LAUNCHED, new Object[]{Math.round(player.func_226277_ct_()), Math.round(player.func_226281_cx_()), player.func_145748_c_().getString()}), Util.field_240973_b_));
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> lore, ITooltipFlag tooltip) {
        super.func_77624_a(stack, world, lore, tooltip);
        lore.add((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_BUSTER_CALL_INFO));
        if (stack.func_196082_o().func_74764_b("countdown")) {
            int t = Math.max((stack.func_196082_o().func_74762_e("countdown") - 180) / 20, 0);
            lore.add((ITextComponent)new StringTextComponent("\u00a76Countdown: " + t + " seconds\u00a7r"));
        }
    }
}

